/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.example_env.block.gui;

import java.util.Optional;
import kasuga.lib.core.menu.locator.BlockMenuLocator;
import kasuga.lib.core.menu.locator.GuiMenuHolder;
import kasuga.lib.example_env.AllExampleElements;
import kasuga.lib.example_env.block.gui.GuiExampleMenu;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class GuiExampleBlockEntity
extends BlockEntity {
    private GuiMenuHolder holder;
    int clickCount = 0;

    public GuiExampleBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(AllExampleElements.guiExampleTile.getType(), pPos, pBlockState);
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
        try {
            this.holder = new GuiMenuHolder.Builder().with(AllExampleElements.MENU_EXAMPLE, menu -> menu.setBlockEntity(this)).locatedAt(BlockMenuLocator.of(this.f_58857_, this.m_58899_())).build();
            this.holder.enable((LevelAccessor)pLevel);
        }
        catch (Exception e) {
            Minecraft.m_91332_((CrashReport)new CrashReport("Failed to create GuiMenuHolder", (Throwable)e));
        }
    }

    public void incrementData() {
        CompoundTag syncData = new CompoundTag();
        syncData.m_128405_("click", ++this.clickCount);
        this.holder.getMenu(0).ifPresent(menu -> menu.broadcast(syncData));
    }

    public void openScreen() {
        this.holder.openScreen(0);
    }

    public void m_7651_() {
        super.m_7651_();
        this.holder.disable();
    }

    public void m_6339_() {
        super.m_6339_();
        this.holder.enable((LevelAccessor)this.f_58857_);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity block) {
        GuiExampleBlockEntity entity = (GuiExampleBlockEntity)block;
        if (level instanceof ServerLevel) {
            // empty if block
        }
    }

    public Optional<GuiExampleMenu> getMenu() {
        return this.holder.getMenu(0).map(t -> {
            GuiExampleMenu menu;
            return t instanceof GuiExampleMenu ? (menu = (GuiExampleMenu)t) : null;
        });
    }
}

