/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.example_env.engine;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interception.logging.JavetStandardConsoleInterceptor;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.values.V8Value;
import kasuga.lib.core.javascript.engine.javet.JavetKasugaConverter;
import kasuga.lib.core.javascript.engine.javet.converter.FastJavetClassConverter;
import kasuga.lib.example_env.engine.ClassBenchmarker;

public class Benchmarker {
    public static String benchmarkCode = "measureTime();\nvar i;\nfor(i=0;i<1000;i++){\n    benchmarker.directCall();\n    var a = benchmarker.directCallWithObjectReturnType();\n    benchmarker.directCallWithObjectParameter(a);\n    benchmarker.directCallWithOverloading(\"Hello,World\");\n}\n\nconsole.info(\"\u0394T1=\", measureTime() / 1000);\n\nmeasureTime();\nfor(i=0;i<10000;i++){\n    benchmarker.directCall();\n}\nconsole.info(\"\u0394TD=\", measureTime() / 1000);\n\nmeasureTime();\nfor(i=0;i<10000;i++){\n    benchmarker.directCallWithOverloading(\"Hello,World\");\n}\nconsole.info(\"\u0394TO=\", measureTime() / 1000);\n\nvar a = benchmarker.directCallWithObjectReturnType();\n\nmeasureTime();\nfor(i=0;i<10000;i++){\n    benchmarker.directCallWithObjectParameter(a);\n}\nconsole.info(\"\u0394TP=\", measureTime() / 1000);\n";

    public static void benchmarkOriginal() throws JavetException {
        Object runtime = V8Host.getV8Instance().createV8Runtime();
        ((V8Runtime)runtime).setConverter(new JavetKasugaConverter((V8Runtime)runtime));
        JavetStandardConsoleInterceptor consoleInterceptor = new JavetStandardConsoleInterceptor((V8Runtime)runtime);
        consoleInterceptor.register(((V8Runtime)runtime).getGlobalObject());
        Object ref = new Object(){
            long initTime = System.nanoTime();
        };
        ((V8Runtime)runtime).getGlobalObject().bindFunction(new JavetCallbackContext("measureTime", JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> Benchmarker.lambda$benchmarkOriginal$f55bb17e$1(ref, runtime, arg_0)));
        System.out.println("-----Benchmarking Result of JavetKasugaConverter-----");
        long nanoTime = System.nanoTime();
        ((V8Runtime)runtime).getGlobalObject().set((Object)"benchmarker", (Object)new ClassBenchmarker());
        System.out.printf("delta T start = %d\n", System.nanoTime() - nanoTime);
        int beforeRef = ((V8Runtime)runtime).getReferenceCount();
        int beforeCtx = ((V8Runtime)runtime).getCallbackContextCount();
        ((V8Runtime)runtime).getExecutor(benchmarkCode).execute();
        ((V8Runtime)runtime).lowMemoryNotification();
        System.gc();
        System.out.printf("delta REF = %d\n", beforeRef - ((V8Runtime)runtime).getReferenceCount());
        System.out.printf("delta CTX = %d\n", beforeCtx - ((V8Runtime)runtime).getCallbackContextCount());
        ((V8Runtime)runtime).close();
    }

    public static void benchmarkNeo() throws JavetException {
        Object runtime = V8Host.getV8Instance().createV8Runtime();
        ((V8Runtime)runtime).setConverter(new FastJavetClassConverter((V8Runtime)runtime));
        JavetStandardConsoleInterceptor consoleInterceptor = new JavetStandardConsoleInterceptor((V8Runtime)runtime);
        consoleInterceptor.register(((V8Runtime)runtime).getGlobalObject());
        Object ref = new Object(){
            long initTime = System.nanoTime();
        };
        ((V8Runtime)runtime).getGlobalObject().bindFunction(new JavetCallbackContext("measureTime", JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> Benchmarker.lambda$benchmarkNeo$829662ff$1(ref, runtime, arg_0)));
        System.out.println("-----Benchmarking Result of FastJavetClassConverter-----");
        long nanoTime = System.nanoTime();
        ((V8Runtime)runtime).getGlobalObject().set((Object)"benchmarker", (Object)new ClassBenchmarker());
        System.out.printf("delta T start = %d\n", System.nanoTime() - nanoTime);
        int beforeRef = ((V8Runtime)runtime).getReferenceCount();
        int beforeCtx = ((V8Runtime)runtime).getCallbackContextCount();
        ((V8Runtime)runtime).getExecutor(benchmarkCode).execute();
        ((V8Runtime)runtime).lowMemoryNotification();
        System.gc();
        System.out.printf("delta REF = %d\n", beforeRef - ((V8Runtime)runtime).getReferenceCount());
        System.out.printf("delta CTX = %d\n", beforeCtx - ((V8Runtime)runtime).getCallbackContextCount());
        ((V8Runtime)runtime).close();
    }

    public static void start() throws JavetException {
        Benchmarker.benchmarkOriginal();
        Benchmarker.benchmarkNeo();
    }

    private static /* synthetic */ V8Value lambda$benchmarkNeo$829662ff$1(2 ref, V8Runtime runtime, V8Value[] object) throws JavetException, Exception {
        long oldInitTime = ref.initTime;
        ref.initTime = System.nanoTime();
        return runtime.getConverter().toV8Value(runtime, (int)(System.nanoTime() - oldInitTime));
    }

    private static /* synthetic */ V8Value lambda$benchmarkOriginal$f55bb17e$1(1 ref, V8Runtime runtime, V8Value[] object) throws JavetException, Exception {
        long oldInitTime = ref.initTime;
        ref.initTime = System.nanoTime();
        return runtime.getConverter().toV8Value(runtime, (int)(System.nanoTime() - oldInitTime));
    }
}

