/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.mixins.mixin.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.HashMap;
import kasuga.lib.core.client.animation.neo_neo.VectorUtil;
import kasuga.lib.core.client.model.ItemTransformProvider;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.GeometryLoaderManager;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.client.renderer.block/model/BlockModel$Deserializer"})
public class MixinBlockModel$Deserializer {
    @Inject(method={"deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/client/renderer/block/model/BlockModel;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/model/BlockModel$Deserializer;getAmbientOcclusion(Lcom/google/gson/JsonObject;)Z")})
    public void doDeserialize(JsonElement json, Type type, JsonDeserializationContext context, CallbackInfoReturnable<BlockModel> callBack) {
        JsonObject object = json.getAsJsonObject();
        if (!object.has("loader")) {
            return;
        }
        ResourceLocation location = new ResourceLocation(object.get("loader").getAsString());
        IGeometryLoader loader = GeometryLoaderManager.get((ResourceLocation)location);
        if (!(loader instanceof ItemTransformProvider)) {
            return;
        }
        ItemTransformProvider provider = (ItemTransformProvider)loader;
        JsonObject transObject = new JsonObject();
        HashMap<ItemTransforms.TransformType, ItemTransform> transforms = provider.generate(object, type, context);
        if (transforms == null) {
            return;
        }
        for (ItemTransforms.TransformType tType : ItemTransforms.TransformType.values()) {
            if (!transforms.containsKey(tType)) continue;
            ItemTransform t = transforms.get(tType);
            JsonArray rotation = VectorUtil.vec3fToJsonArray(t.f_111755_);
            JsonArray translation = VectorUtil.vec3fToJsonArray(t.f_111756_);
            JsonArray scale = VectorUtil.vec3fToJsonArray(t.f_111757_);
            JsonArray rightRotation = VectorUtil.vec3fToJsonArray(t.rightRotation);
            JsonObject transObj = new JsonObject();
            transObj.add("rotation", (JsonElement)rotation);
            transObj.add("translation", (JsonElement)translation);
            transObj.add("scale", (JsonElement)scale);
            transObj.add("right_rotation", (JsonElement)rightRotation);
            transObject.add(tType.getSerializeName(), (JsonElement)transObj);
        }
        object.add("display", (JsonElement)transObject);
    }
}

