/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.mixins.mixin.create;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import kasuga.lib.KasugaLib;
import kasuga.lib.mixins.mixin.create.TrackGraphAccessor;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GlobalRailwayManager.class}, remap=false)
public class GlobalRailwayManagerMixin {
    @Shadow
    public Map<UUID, TrackGraph> trackNetworks;

    @Inject(method={"loadTrackData"}, at={@At(value="TAIL")})
    public void onLoadTrackData(MinecraftServer server, CallbackInfo ci) {
        KasugaLib.STACKS.RAILWAY.load(server.m_129783_());
        KasugaLib.STACKS.RAILWAY.get().syncExtraData(Create.RAILWAYS.trackNetworks.keySet());
        this.trackNetworks.forEach((uuid, graph) -> {
            HashSet<TrackEdge> edges = new HashSet<TrackEdge>();
            for (Map<TrackNode, TrackEdge> value : ((TrackGraphAccessor)graph).getConnectionsByNode().values()) {
                for (TrackEdge edge : value.values()) {
                    edges.add(edge);
                }
            }
            KasugaLib.STACKS.RAILWAY.get().withGraph((TrackGraph)graph).syncWithExternal(edges);
        });
    }

    @Inject(method={"putGraph"}, at={@At(value="TAIL")})
    public void onPutGraph(TrackGraph graph, CallbackInfo ci) {
        if ((GlobalRailwayManager)this != Create.RAILWAYS) {
            return;
        }
        KasugaLib.STACKS.RAILWAY.get().createExtraData(graph.id);
    }

    @Inject(method={"removeGraph"}, at={@At(value="TAIL")})
    public void onRemoveGraph(TrackGraph graph, CallbackInfo ci) {
        if ((GlobalRailwayManager)this != Create.RAILWAYS) {
            return;
        }
        KasugaLib.STACKS.RAILWAY.get().removeExtraData(graph.id);
    }

    @Inject(method={"addTrain"}, at={@At(value="TAIL")})
    public void onAddTrain(Train train, CallbackInfo ci) {
        if ((GlobalRailwayManager)this != Create.RAILWAYS) {
            return;
        }
        KasugaLib.STACKS.RAILWAY.get().putTrainExtraData(train);
    }

    @Inject(method={"removeTrain"}, at={@At(value="TAIL")})
    public void onRemoveTrain(UUID id, CallbackInfo ci) {
        if ((GlobalRailwayManager)this != Create.RAILWAYS) {
            return;
        }
        KasugaLib.STACKS.RAILWAY.get().removeTrainExtraData(id);
    }
}

