/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.mixins.mixin.create;

import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.foundation.utility.Couple;
import java.util.Map;
import javax.annotation.Nullable;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.create.graph.GraphExtraData;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TrackGraph.class}, remap=false)
public abstract class TrackGraphMixin {
    @Shadow
    private Map<TrackNode, Map<TrackNode, TrackEdge>> connectionsByNode;

    @Shadow
    public abstract TrackNode getNode(int var1);

    @Shadow
    public abstract TrackNode locateNode(TrackNodeLocation var1);

    @Shadow
    public abstract Map<TrackNode, TrackEdge> getConnectionsFrom(TrackNode var1);

    @Inject(method={"transferAll"}, at={@At(value="TAIL")})
    public void onTransferAll(TrackGraph toOther, CallbackInfo ci) {
        GraphExtraData toOtherExtra = KasugaLib.STACKS.RAILWAY.get().withGraph(toOther);
        KasugaLib.STACKS.RAILWAY.get().withGraph((TrackGraph)this).transferAll(toOtherExtra);
    }

    @Inject(method={"transfer"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onTransfer(LevelAccessor level, TrackNode node, TrackGraph target, CallbackInfo ci) {
        if (level.m_5776_()) {
            return;
        }
        Map<TrackNode, TrackEdge> connections = this.getConnectionsFrom(node);
        GraphExtraData targetExtraData = KasugaLib.STACKS.RAILWAY.get().withGraph(target);
        KasugaLib.STACKS.RAILWAY.get().withGraph((TrackGraph)this).transfer(level, node, connections, targetExtraData);
    }

    @Inject(method={"connectNodes"}, at={@At(value="TAIL")})
    void onConnectNodes(LevelAccessor reader, TrackNodeLocation.DiscoveredLocation location, TrackNodeLocation.DiscoveredLocation location2, @Nullable BezierConnection turn, CallbackInfo ci) {
        if (reader.m_5776_()) {
            return;
        }
        TrackNode node1 = this.locateNode((TrackNodeLocation)location);
        TrackNode node2 = this.locateNode((TrackNodeLocation)location2);
        TrackEdge edge = ((TrackGraph)this).getConnection(Couple.create((Object)node1, (Object)node2));
        TrackEdge edgeReverse = ((TrackGraph)this).getConnection(Couple.create((Object)node2, (Object)node1));
        KasugaLib.STACKS.RAILWAY.get().withGraph((TrackGraph)this).createEdge(edge);
        KasugaLib.STACKS.RAILWAY.get().withGraph((TrackGraph)this).createEdge(edgeReverse);
    }

    @Inject(method={"removeNode"}, at={@At(value="HEAD")})
    void onRemoveNodes(@Nullable LevelAccessor reader, TrackNodeLocation location, CallbackInfoReturnable ci) {
        if (reader == null || reader.m_5776_()) {
            return;
        }
        TrackNode node = this.locateNode(location);
        if (node == null) {
            return;
        }
        Map<TrackNode, TrackEdge> connections = this.getConnectionsFrom(node);
        connections.forEach((_node, edge) -> KasugaLib.STACKS.RAILWAY.get().withGraph((TrackGraph)this).removeEdge((TrackEdge)edge));
        for (TrackNode fromNodes : connections.keySet()) {
            if (!this.connectionsByNode.containsKey(fromNodes)) continue;
            TrackEdge edge2 = this.connectionsByNode.get(fromNodes).get(node);
            KasugaLib.STACKS.RAILWAY.get().withGraph((TrackGraph)this).removeEdge(edge2);
        }
    }
}

