/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.mixins.mixin.create;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.create.edge_point.BogeyObserverEdgePoint;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Train.class}, remap=false)
public abstract class TrainMixin {
    @Shadow
    protected abstract void updateNavigationTarget(double var1);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;updateNavigationTarget(D)V"))
    public void doUpdateNavigationTarget(Train train, double distance) {
        this.updateNavigationTarget(distance);
        KasugaLib.STACKS.RAILWAY.getIntergartor(train).addDistance(distance);
    }

    @Inject(method={"frontSignalListener"}, at={@At(value="RETURN")}, cancellable=true)
    public void doFrontSignalListener(CallbackInfoReturnable<TravellingPoint.IEdgePointListener> ci) {
        TravellingPoint.IEdgePointListener oldListener = (TravellingPoint.IEdgePointListener)ci.getReturnValue();
        ci.setReturnValue((distance, pair) -> {
            TrackEdgePoint edgePoint = (TrackEdgePoint)pair.getFirst();
            if (edgePoint instanceof BogeyObserverEdgePoint) {
                BogeyObserverEdgePoint observerEdgePoint = (BogeyObserverEdgePoint)edgePoint;
                observerEdgePoint.notifyBogey((Train)this);
                return false;
            }
            return oldListener.test(distance, pair);
        });
    }

    @Inject(method={"backSignalListener"}, at={@At(value="RETURN")}, cancellable=true)
    public void doBackSignalListener(CallbackInfoReturnable<TravellingPoint.IEdgePointListener> ci) {
        TravellingPoint.IEdgePointListener oldListener = (TravellingPoint.IEdgePointListener)ci.getReturnValue();
        ci.setReturnValue((distance, pair) -> {
            TrackEdgePoint edgePoint = (TrackEdgePoint)pair.getFirst();
            if (edgePoint instanceof BogeyObserverEdgePoint) {
                BogeyObserverEdgePoint observerEdgePoint = (BogeyObserverEdgePoint)edgePoint;
                observerEdgePoint.notifyBogey((Train)this);
                return false;
            }
            return oldListener.test(distance, pair);
        });
    }
}

