/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations;

import java.util.HashMap;
import java.util.LinkedList;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.registry.SimpleRegistry;

public class BundledReg<T extends Reg>
extends Reg {
    private final LinkedList<RegAction<T>> actions = new LinkedList();
    private final HashMap<String, LinkedList<RegAction<T>>> specificActions = new HashMap();
    private final LinkedList<RegDrive<T>> specificDrive = new LinkedList();
    private final LinkedList<String> elements = new LinkedList();
    private final HashMap<String, T> regs = new HashMap();
    private RegFactory<T> factory = null;

    public BundledReg(String registrationKey) {
        super(registrationKey);
    }

    @Mandatory
    public BundledReg<T> factory(RegFactory<T> factory) {
        this.factory = factory;
        return this;
    }

    @Optional
    public BundledReg<T> element(String registrationKey) {
        this.elements.add(registrationKey);
        this.regs.put(registrationKey, this.factory.build(registrationKey));
        return this;
    }

    @Optional
    public BundledReg<T> action(RegAction<T> action) {
        this.actions.add(action);
        return this;
    }

    @Optional
    public BundledReg<T> specificAction(String key, RegAction<T> action) {
        if (this.specificActions.containsKey(key)) {
            this.specificActions.get(key).add(action);
        } else {
            LinkedList<RegAction<T>> list = new LinkedList<RegAction<T>>();
            list.add(action);
            this.specificActions.put(key, list);
        }
        return this;
    }

    @Optional
    public BundledReg<T> drive(RegDrive<T> drive) {
        this.specificDrive.add(drive);
        return this;
    }

    @Override
    @Mandatory
    public BundledReg<T> submit(SimpleRegistry registry) {
        if (this.factory == null) {
            return this;
        }
        for (String key : this.elements) {
            Reg reg = (Reg)this.regs.get(key);
            for (RegAction regAction : this.actions) {
                regAction.action(reg);
            }
            LinkedList specific = this.specificActions.getOrDefault(key, null);
            for (RegDrive regDrive : this.specificDrive) {
                regDrive.action(key, reg);
            }
            if (specific != null) {
                for (RegAction regAction : specific) {
                    regAction.action(reg);
                }
            }
            reg.submit(registry);
        }
        return this;
    }

    public HashMap<String, T> getElements() {
        return this.regs;
    }

    public T getElement(String key) {
        return (T)((Reg)this.regs.getOrDefault(key, null));
    }

    public boolean containsElement(String key) {
        return this.regs.containsKey(key);
    }

    @Override
    public String getIdentifier() {
        return "bundled";
    }

    public static interface RegFactory<T extends Reg> {
        public T build(String var1);
    }

    public static interface RegAction<T extends Reg> {
        public T action(T var1);
    }

    public static interface RegDrive<T extends Reg> {
        public T action(String var1, T var2);
    }
}

