/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.function.Consumer;
import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.network.C2SPacket;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.ChannelReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import kasuga.lib.vendor_modules.org.apache.commons.lang3.builder.EqualsBuilder;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.network.NetworkEvent;

public class KeyBindingReg
extends Reg {
    public final String translationKey;
    public final String category;
    private int keyCode = -1;
    private KeyMapping mapping;
    private Environment env = Environment.ALL;
    private Consumer<LocalPlayer> clientHandler;
    private Consumer<ServerPlayer> serverHandler;
    private KeyModifier modifier = KeyModifier.NONE;
    private InputConstants.Type type = InputConstants.Type.KEYSYM;
    private static final ChannelReg keyChannel = new ChannelReg("kasuga_lib_key_bindings").brand("1.0").loadPacket(KeySyncPacket.class, KeySyncPacket::new).submit(KasugaLibStacks.REGISTRY);
    private static final LinkedList<KeyBindingReg> registered = new LinkedList();

    public KeyBindingReg(String translationKey, String categoryName) {
        super(translationKey);
        this.translationKey = translationKey;
        this.category = categoryName;
    }

    public KeyBindingReg setClientHandler(Consumer<LocalPlayer> consumer) {
        this.clientHandler = consumer;
        return this;
    }

    public KeyBindingReg setServerHandler(Consumer<ServerPlayer> consumer) {
        this.serverHandler = consumer;
        return this;
    }

    public KeyBindingReg setModifier(KeyModifier modifier) {
        this.modifier = modifier;
        return this;
    }

    public KeyBindingReg setKeycode(int defaultKeyCode, InputConstants.Type type) {
        this.keyCode = defaultKeyCode;
        this.type = type;
        return this;
    }

    public KeyBindingReg setEnvironment(Environment env) {
        this.env = env;
        return this;
    }

    @Override
    public KeyBindingReg submit(SimpleRegistry registry) {
        if (this.keyCode <= -1) {
            throw new IllegalArgumentException("Invalid keycode");
        }
        this.mapping = new KeyMapping(this.registrationKey, (IKeyConflictContext)this.env.context, this.modifier, this.type, this.keyCode, this.category);
        registry.key().put(this.toString(), this);
        registered.add(this);
        return this;
    }

    public KeyMapping getMapping() {
        return this.mapping;
    }

    @Inner
    public static void onClientTick() {
        registered.stream().filter(reg -> reg.mapping.m_90859_()).forEach(reg -> {
            if (reg.clientHandler != null) {
                reg.clientHandler.accept(Minecraft.m_91087_().f_91074_);
            }
            keyChannel.sendToServer(new KeySyncPacket().setProperties(reg.toString()));
        });
    }

    @Override
    public String getIdentifier() {
        return "key_binding";
    }

    @Override
    @Inner
    public String toString() {
        return this.keyCode + this.category + this.mapping.getKey() + this.mapping.m_90860_() + this.mapping.m_90858_();
    }

    @Inner
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBindingReg that = (KeyBindingReg)o;
        return new EqualsBuilder().append(this.keyCode, that.keyCode).append((Object)this.category, (Object)that.category).append((Object)this.registrationKey, (Object)that.registrationKey).isEquals();
    }

    public static void invoke() {
    }

    public static enum Environment {
        ALL(KeyConflictContext.UNIVERSAL),
        IN_GUI(KeyConflictContext.GUI),
        IN_GAME(KeyConflictContext.IN_GAME);

        private final KeyConflictContext context;

        private Environment(KeyConflictContext context) {
            this.context = context;
        }
    }

    private static class KeySyncPacket
    extends C2SPacket {
        String key;

        public KeySyncPacket() {
        }

        public KeySyncPacket(FriendlyByteBuf buf) {
            super(buf);
            int length = buf.readInt();
            this.key = (String)buf.readCharSequence(length, StandardCharsets.UTF_8);
        }

        public KeySyncPacket setProperties(String key) {
            this.key = key;
            return this;
        }

        @Override
        public void handle(NetworkEvent.Context context) {
            KeyBindingReg keyBinding = registered.stream().filter(reg -> reg.toString().equals(this.key)).toList().get(0);
            if (keyBinding.serverHandler != null) {
                keyBinding.serverHandler.accept(context.getSender());
            }
        }

        @Override
        public void encode(FriendlyByteBuf buf) {
            buf.writeInt(this.key.length());
            buf.writeCharSequence((CharSequence)this.key, StandardCharsets.UTF_8);
        }
    }
}

