/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.client;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.client.render.model.MultiPartModel;
import kasuga.lib.core.client.render.model.SimpleModel;
import kasuga.lib.core.util.Resources;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class ModelReg
extends Reg {
    public static final String COMBINE_CODEC = "multi_part";
    SimpleModel baked;
    private final HashMap<String, ResourceLocation> mappingForBones;
    private final ResourceLocation location;
    boolean multiPart = false;

    public ModelReg(String registrationKey, ResourceLocation location) {
        super(registrationKey);
        this.location = location;
        this.baked = new SimpleModel(registrationKey, null);
        this.mappingForBones = new HashMap();
    }

    @Override
    @Mandatory
    public ModelReg submit(SimpleRegistry registry) {
        registry.model().register(this);
        return this;
    }

    @Override
    public String getIdentifier() {
        return "model";
    }

    public ResourceLocation location() {
        return this.location;
    }

    public boolean isMultiPart() {
        return this.multiPart;
    }

    public SimpleModel getModel() {
        return this.baked;
    }

    @Inner
    public HashMap<String, ResourceLocation> getMappings() {
        return this.mappingForBones;
    }

    @Inner
    public void rebuildAsMultiPart() {
        this.baked = new MultiPartModel(this.registrationKey);
    }

    @Inner
    public void putModelIn(SimpleModel model) {
        this.baked.copyModelFrom(model);
    }

    @Inner
    public void compileFile(SimpleRegistry registry) throws IOException {
        ResourceLocation location = new ResourceLocation(registry.namespace, "models/" + this.location.m_135815_() + ".json");
        Resource resource = this.getResource(location);
        if (resource == null) {
            return;
        }
        JsonObject json = JsonParser.parseReader((JsonReader)new JsonReader((Reader)resource.m_215508_())).getAsJsonObject();
        if (!json.has(COMBINE_CODEC)) {
            return;
        }
        this.multiPart = true;
        JsonObject members = json.getAsJsonObject(COMBINE_CODEC);
        ArrayList<Map.Entry<String, ResourceLocation>> entries = ModelReg.getMapFromJson(members, "");
        for (int i = 0; i < entries.size(); ++i) {
            Map.Entry<String, ResourceLocation> entry = entries.get(i);
            ResourceLocation location1 = this.getModelLocation(entry.getValue());
            JsonObject obj = this.presentIfIsMulti(location1);
            if (obj == null) continue;
            entries.addAll(ModelReg.getMapFromJson(obj, entry.getKey()));
            entries.remove(entry);
            --i;
        }
        for (Map.Entry<String, ResourceLocation> entry : entries) {
            this.mappingForBones.put(entry.getKey(), entry.getValue());
        }
    }

    @Inner
    private ResourceLocation getModelLocation(ResourceLocation location) {
        return new ResourceLocation(location.m_135827_(), "models/" + location.m_135815_() + ".json");
    }

    @Inner
    private static ArrayList<Map.Entry<String, ResourceLocation>> getMapFromJson(JsonObject members, String prefix) {
        Object former = prefix.equals("") ? prefix : prefix + ".";
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map m = (Map)KasugaLib.GSON.fromJson((JsonElement)members, type);
        ArrayList<Map.Entry<String, ResourceLocation>> entries = new ArrayList<Map.Entry<String, ResourceLocation>>();
        for (String key : m.keySet()) {
            entries.add(new AbstractMap.SimpleEntry<CallSite, ResourceLocation>((CallSite)((Object)((String)former + key)), new ResourceLocation((String)m.get(key))));
        }
        return entries;
    }

    @Inner
    private Resource getResource(ResourceLocation location) throws IOException {
        Map<String, Resource> map = Resources.getResources(location, true);
        Resource resource = null;
        if (!map.isEmpty()) {
            for (String s : map.keySet()) {
                resource = map.get(s);
            }
        }
        return resource;
    }

    @Inner
    private JsonObject presentIfIsMulti(ResourceLocation location) throws IOException {
        Resource resource = this.getResource(location);
        if (resource == null) {
            return null;
        }
        JsonObject json = JsonParser.parseReader((JsonReader)new JsonReader((Reader)resource.m_215508_())).getAsJsonObject();
        if (!json.has(COMBINE_CODEC)) {
            return null;
        }
        return json.getAsJsonObject(COMBINE_CODEC);
    }
}

