/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.base.commands.ArgumentTypes.BaseArgument;
import kasuga.lib.core.base.commands.CommandHandler;
import kasuga.lib.core.base.commands.CommandNode;
import kasuga.lib.core.base.commands.CommandTree;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.ArgumentTypeReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class CommandReg
extends Reg {
    private static final LinkedList<CommandReg> ENTRIES = new LinkedList();
    private final String commandName;
    private final CommandTree tree;
    private CommandHandler handler;
    private boolean optionalStartFlag = false;
    private int permission = 2;
    private static final HashMap<String, Pair<LiteralArgumentBuilder<CommandSourceStack>, Dist>> ROOTS = new HashMap();
    public static final HashMap<ResourceLocation, BaseArgument> types = new HashMap();

    public CommandReg(String registrationKey) {
        super(registrationKey);
        this.commandName = registrationKey;
        this.tree = new CommandTree(new CommandNode(registrationKey));
        ROOTS.put(registrationKey, Pair.of(Commands.m_82127_((String)registrationKey), null));
    }

    public CommandReg addLiteral(String string, boolean isOptional) {
        this.tree.addLiteral(isOptional, string);
        if (this.optionalStartFlag && !isOptional) {
            throw new IllegalArgumentException();
        }
        this.optionalStartFlag = isOptional;
        return this;
    }

    public CommandReg addParam(String defaultName, boolean isOptional, Class target) {
        this.tree.addNode(isOptional, defaultName, ArgumentTypeReg.types.get(target.getName()).getSecond());
        if (this.optionalStartFlag && !isOptional) {
            throw new IllegalArgumentException();
        }
        this.optionalStartFlag = isOptional;
        return this;
    }

    public CommandReg addByte(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, Boolean.TYPE);
    }

    public CommandReg addShort(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, Short.TYPE);
    }

    public CommandReg addCharacter(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, Character.TYPE);
    }

    public CommandReg addInteger(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, Integer.TYPE);
    }

    public CommandReg addLong(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, Long.TYPE);
    }

    public CommandReg addFloat(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, Float.TYPE);
    }

    public CommandReg addDouble(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, Double.TYPE);
    }

    public CommandReg addBoolean(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, Boolean.TYPE);
    }

    public CommandReg addString(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, String.class);
    }

    public CommandReg addResourceLocation(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, ResourceLocation.class);
    }

    public CommandReg addURL(String defaultName, boolean isOptional) {
        return this.addParam(defaultName, isOptional, URL.class);
    }

    public CommandReg requirePermissionLevel(int level) {
        if (level < 0) {
            level = 0;
        }
        if (level > 4) {
            level = 4;
        }
        this.permission = level;
        return this;
    }

    public CommandReg onlyIn(Dist dist) {
        ROOTS.remove(this.commandName);
        ROOTS.put(this.commandName, Pair.of(Commands.m_82127_((String)this.registrationKey), dist));
        return this;
    }

    public CommandReg setHandler(CommandHandler runnable) {
        this.handler = runnable;
        return this;
    }

    @Override
    public CommandReg submit(SimpleRegistry registry) {
        ENTRIES.add(this);
        registry.command().put(this.commandName, this);
        return this;
    }

    @Override
    public String getIdentifier() {
        return "command";
    }

    @Inner
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        ENTRIES.forEach(CommandReg::register);
        ROOTS.values().forEach(pair -> {
            if (pair.getSecond() == null) {
                dispatcher.register((LiteralArgumentBuilder)pair.getFirst());
                return;
            }
            switch ((Dist)pair.getSecond()) {
                case CLIENT: {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> dispatcher.register((LiteralArgumentBuilder)pair.getFirst()));
                    break;
                }
                case DEDICATED_SERVER: {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> dispatcher.register((LiteralArgumentBuilder)pair.getFirst()));
                }
            }
        });
    }

    @Inner
    private static void register(CommandReg commandReg) {
        if (commandReg.handler == null) {
            throw new NullPointerException();
        }
        Iterator iterator = commandReg.tree.leaves.iterator();
        block0: while (iterator.hasNext()) {
            CommandNode leaf;
            CommandNode commandNode = leaf = (CommandNode)iterator.next();
            LiteralArgumentBuilder<CommandSourceStack> builder = ROOTS.get(commandReg.commandName).getFirst();
            ArgumentBuilder argument = null;
            if (commandNode.isRoot()) {
                builder.executes(commandReg.handler::executeWithContext);
                continue;
            }
            while (true) {
                ArgumentBuilder post;
                if (commandNode.isLeaf) {
                    post = CommandNode.parseArgumentType(commandNode).requires(p -> p.m_6761_(commandReg.permission)).executes(commandReg.handler::executeWithContext);
                    if (commandNode.father.isRoot()) {
                        builder.then(post);
                        continue block0;
                    }
                } else {
                    post = argument;
                }
                if (commandNode.father.isRoot()) {
                    builder.then(argument == null ? CommandNode.parseArgumentType(commandNode) : argument);
                    continue block0;
                }
                commandNode = commandNode.father;
                if (commandNode.children.stream().anyMatch(commandNode1 -> commandNode1.required)) {
                    argument = CommandNode.parseArgumentType(commandNode).then(post);
                    continue;
                }
                argument = CommandNode.parseArgumentType(commandNode).requires(p -> p.m_6761_(commandReg.permission)).executes(commandReg.handler::executeWithContext).then(post);
            }
        }
    }
}

