/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ConfiguredFeatureReg<T extends Block>
extends Reg {
    private int quantityPerGroup = 9;
    private final List<Supplier<OreConfiguration.TargetBlockState>> oreConfigTargetList = new ArrayList<Supplier<OreConfiguration.TargetBlockState>>();
    private RegistryObject<ConfiguredFeature<?, ?>> registryObject = null;

    public ConfiguredFeatureReg(String registrationKey) {
        super(registrationKey);
    }

    public ConfiguredFeatureReg<T> addOreConfigTarget(BlockReg<T> ore) {
        return this.addOreConfigTarget(ore::getBlock);
    }

    public ConfiguredFeatureReg<T> addOreConfigTarget(Supplier<T> ore) {
        this.oreConfigTargetList.add(() -> OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)ore.get()).m_49966_()));
        return this;
    }

    public ConfiguredFeatureReg<T> addDeepSlateOreConfigTarget(BlockReg<T> ore) {
        return this.addDeepSlateOreConfigTarget(ore::getBlock);
    }

    public ConfiguredFeatureReg<T> addDeepSlateOreConfigTarget(Supplier<T> ore) {
        this.oreConfigTargetList.add(() -> OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)ore.get()).m_49966_()));
        return this;
    }

    public ConfiguredFeatureReg<T> addOreConfigTargetByRule(RuleTest replacedBlockRuleTest, Supplier<T> ore) {
        this.oreConfigTargetList.add(() -> OreConfiguration.m_161021_((RuleTest)replacedBlockRuleTest, (BlockState)((Block)ore.get()).m_49966_()));
        return this;
    }

    public ConfiguredFeatureReg<T> addOreConfigTargetByKey(TagKey<Block> blockTagKey, Supplier<T> ore) {
        this.oreConfigTargetList.add(() -> OreConfiguration.m_161021_((RuleTest)new TagMatchTest(blockTagKey), (BlockState)((Block)ore.get()).m_49966_()));
        return this;
    }

    public ConfiguredFeatureReg<T> addOreConfigTargetByBlock(ResourceLocation block, Supplier<T> ore) {
        this.oreConfigTargetList.add(() -> {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(block);
            if (b == null) {
                return null;
            }
            return OreConfiguration.m_161021_((RuleTest)new BlockMatchTest(b), (BlockState)((Block)ore.get()).m_49966_());
        });
        return this;
    }

    public ConfiguredFeatureReg<T> setQuantityPerGroup(int count) {
        this.quantityPerGroup = count;
        return this;
    }

    @Override
    public ConfiguredFeatureReg<T> submit(SimpleRegistry registry) {
        this.registryObject = registry.configuredFeature().register(this.registrationKey, () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(this.getOreConfigTargetList(), this.quantityPerGroup)));
        return this;
    }

    @Override
    public String getIdentifier() {
        return "configured_feature";
    }

    public int getQuantityPerGroup() {
        return this.quantityPerGroup;
    }

    public List<Supplier<OreConfiguration.TargetBlockState>> getOreConfigTargetSupplierList() {
        return this.oreConfigTargetList;
    }

    public List<OreConfiguration.TargetBlockState> getOreConfigTargetList() {
        ArrayList<OreConfiguration.TargetBlockState> list = new ArrayList<OreConfiguration.TargetBlockState>(this.oreConfigTargetList.size());
        this.oreConfigTargetList.forEach(sup -> {
            if (sup == null) {
                return;
            }
            list.add((OreConfiguration.TargetBlockState)sup.get());
        });
        return list;
    }

    public RegistryObject<ConfiguredFeature<?, ?>> getRegistryObject() {
        return this.registryObject;
    }
}

