/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraftforge.registries.RegistryObject;

public class EffectReg<T extends MobEffect>
extends Reg {
    private MobEffectCategory category = MobEffectCategory.NEUTRAL;
    private RegistryObject<T> registryObject = null;
    private EffectBuilder<T> builder = null;
    private ArrayList<Consumer<T>> attributes = new ArrayList();
    private int color = 0xFFFFFF;

    public EffectReg(String registrationKey) {
        super(registrationKey);
    }

    @Mandatory
    public EffectReg<T> effectType(@Nonnull EffectBuilder<? extends MobEffect> builder) {
        this.builder = builder;
        return this;
    }

    @Mandatory
    public EffectReg<T> category(MobEffectCategory category) {
        this.category = category;
        return this;
    }

    @Optional
    public EffectReg<T> color(int r, int g, int b) {
        this.color = r * 256 * 256 + g * 256 + b;
        return this;
    }

    @Optional
    public EffectReg<T> color(int integerColor) {
        this.color = integerColor;
        return this;
    }

    @Optional
    public EffectReg<T> attritube(Consumer<T> attributeModifier) {
        this.attributes.add(attributeModifier);
        return this;
    }

    @Override
    public EffectReg<T> submit(SimpleRegistry registry) {
        if (this.builder == null) {
            this.crashOnNotPresent(EffectBuilder.class, "effectType", "submit");
        }
        this.registryObject = registry.mob_effect().register(this.registrationKey, () -> {
            Object effect = this.builder.build(this.category, this.color);
            this.attributes.forEach((Consumer<Consumer<T>>)((Consumer<Consumer>)c -> c.accept(effect)));
            return effect;
        });
        return this;
    }

    public RegistryObject<T> getRegistryObject() {
        return this.registryObject;
    }

    public T getEffect() {
        return (T)(this.registryObject == null ? null : (MobEffect)this.registryObject.get());
    }

    public MobEffectCategory getCategory() {
        return this.category;
    }

    public int getThemeColor() {
        return this.color;
    }

    @Override
    public String getIdentifier() {
        return "effect";
    }

    public static interface EffectBuilder<T extends MobEffect> {
        public T build(MobEffectCategory var1, int var2);
    }
}

