/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.common.BucketItemReg;
import kasuga.lib.registrations.common.CreativeTabReg;
import kasuga.lib.registrations.common.FluidBlockReg;
import kasuga.lib.registrations.common.FluidTagReg;
import kasuga.lib.registrations.common.ItemReg;
import kasuga.lib.registrations.common.MenuReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidReg<E extends ForgeFlowingFluid>
extends Reg {
    private RegistryObject<E> stillObject = null;
    private RegistryObject<E> flowingObject = null;
    private final FluidType.Properties properties = FluidType.Properties.create();
    private ForgeFlowingFluid.Properties fluidProp = null;
    private FluidBuilder<E> stillBuilder = null;
    private FluidBuilder<E> flowingBuilder = null;
    private final ArrayList<PropertyBuilder> propertyBuilders;
    private BucketItemReg<? extends BucketItem> itemReg = null;
    private final ArrayList<FluidPropertyBuilder> builders = new ArrayList();
    private FluidBlockReg<? extends LiquidBlock> block;
    private FluidType type = null;
    private String stillTexturePath = null;
    private String flowingTexturePath = null;
    private String overlayTexturePath = null;
    private MenuReg<?, ?> menuReg = null;
    private int tintColor = 0xFFFFFF;
    boolean registerItem = false;
    boolean registerBlock = false;
    boolean registerMenu = false;
    private final FluidTagReg tag;
    private String renderType = "solid";
    private Vector3f fogColor = null;
    private CustomFillEvent customFillEvent;
    private Supplier<Item> bucketSupplier;
    private String stillRegKey;
    private String flowingRegKey;

    public FluidReg(String registrationKey) {
        super(registrationKey);
        this.block = new FluidBlockReg(registrationKey);
        this.propertyBuilders = new ArrayList();
        this.tag = new FluidTagReg("forge", registrationKey, "fluids/" + registrationKey);
        this.stillRegKey = registrationKey;
        this.flowingRegKey = registrationKey + "_flow";
        this.customFillEvent = null;
        this.bucketSupplier = () -> ((Item)Items.f_42446_).m_5456_();
    }

    @Mandatory
    public FluidReg<E> still(FluidBuilder<? extends E> builder, String stillTexPath) {
        this.stillBuilder = builder;
        this.stillTexturePath = stillTexPath;
        return this;
    }

    @Optional
    public FluidReg<E> still(FluidBuilder<? extends E> builder, String registerName, String stillTexPath) {
        this.stillBuilder = builder;
        this.stillTexturePath = stillTexPath;
        this.stillRegKey = registerName;
        return this;
    }

    @Mandatory
    public FluidReg<E> flow(FluidBuilder<? extends E> builder, String flowingTexPath) {
        this.flowingBuilder = builder;
        this.flowingTexturePath = flowingTexPath;
        return this;
    }

    @Optional
    public FluidReg<E> flow(FluidBuilder<? extends E> builder, String registerName, String flowingTexPath) {
        this.flowingBuilder = builder;
        this.flowingTexturePath = flowingTexPath;
        this.flowingRegKey = registerName;
        return this;
    }

    public FluidReg<E> decreasePreBlock(int decrease) {
        return this.fluidProperty(prop -> prop.levelDecreasePerBlock(decrease));
    }

    public FluidReg<E> slopeFindDistance(int distance) {
        return this.fluidProperty(prop -> prop.slopeFindDistance(distance));
    }

    public FluidReg<E> explosionResistance(float resistance) {
        return this.fluidProperty(prop -> prop.explosionResistance(resistance));
    }

    public FluidReg<E> tickRate(int tickRate) {
        return this.fluidProperty(prop -> prop.tickRate(tickRate));
    }

    public FluidReg<E> numericProperties(int decrease, int distance, int tickRate, float resistance) {
        return this.decreasePreBlock(decrease).slopeFindDistance(distance).tickRate(tickRate).explosionResistance(resistance);
    }

    @Mandatory
    public FluidReg<E> blockType(FluidBlockReg.FluidBlockBuilder<? extends LiquidBlock> builder) {
        this.block.blockType(builder);
        this.builders.add(prop -> prop.block(this.block::getBlock));
        this.registerBlock = true;
        return this;
    }

    public FluidReg<E> blockType(FluidBlockReg<? extends LiquidBlock> reg) {
        this.block = reg;
        this.builders.add(prop -> prop.block(this.block::getBlock));
        this.registerBlock = false;
        return this;
    }

    @Optional
    public FluidReg<E> type(FluidType type) {
        this.type = type;
        return this;
    }

    @Mandatory
    public <R extends BucketItem> FluidReg<E> bucketItem(BucketItemReg.BucketBuilder<? extends BucketItem> builder) {
        return this.bucketItem(this.registrationKey + "_bucket", builder);
    }

    public <R extends BucketItem> FluidReg<E> bucketItem(String itemRegistrationKey, BucketItemReg.BucketBuilder<? extends BucketItem> builder) {
        this.itemReg = new BucketItemReg(itemRegistrationKey);
        this.itemReg.itemType(builder);
        this.itemReg.fluidType(this::stillFluid);
        this.registerItem = true;
        return this;
    }

    public FluidReg<E> bucketItem(BucketItemReg<? extends BucketItem> reg) {
        this.itemReg = reg;
        this.registerItem = false;
        return this;
    }

    public FluidReg<E> setCustomFillEvent(CustomFillEvent event) {
        this.customFillEvent = event;
        return this;
    }

    public FluidReg<E> setEmptyBucket(Supplier<Item> bucket) {
        this.bucketSupplier = bucket;
        return this;
    }

    @Optional
    public FluidReg<E> bucketModel(ResourceLocation resourceLocation) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "bucketModel");
            return this;
        }
        this.itemReg.model(resourceLocation);
        return this;
    }

    @Optional
    public FluidReg<E> itemProperty(ItemReg.PropertyIdentifier identifier) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "itemProperty");
            return this;
        }
        this.itemReg.withProperty(identifier);
        return this;
    }

    @Optional
    public FluidReg<E> shouldCustomRenderItem(boolean flag) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "shouldCustomRenderItem");
            return this;
        }
        this.itemReg.shouldCustomRender(flag);
        return this;
    }

    @Optional
    public FluidReg<E> tab(CreativeModeTab tab) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "tab");
            return this;
        }
        this.itemReg.tab(tab);
        return this;
    }

    @Optional
    public FluidReg<E> tab(CreativeTabReg reg) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "tab");
            return this;
        }
        this.itemReg.tab(reg);
        return this;
    }

    @Optional
    public FluidReg<E> stackTo(int size) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "stackTo");
            return this;
        }
        this.itemReg.stackTo(size);
        return this;
    }

    @Optional
    public <F extends AbstractContainerMenu, U extends Screen> FluidReg<E> withMenu(String registrationKey, IContainerFactory<?> menu, Supplier<MenuReg.FullScreenInvoker<F, U>> screen) {
        this.menuReg = new MenuReg(registrationKey).withMenuAndScreen(menu, screen);
        this.registerMenu = true;
        return this;
    }

    @Optional
    public FluidReg<E> withMenu(MenuReg<?, ?> menuReg) {
        this.menuReg = menuReg;
        this.registerMenu = false;
        return this;
    }

    @Optional
    public FluidReg<E> withBlockProperty(BlockReg.PropertyIdentifier identifier) {
        if (this.block == null) {
            this.crashOnNotPresent(FluidBlockReg.class, "fluidBlockReg", "withBlockProperty");
            return this;
        }
        this.block.addProperty(identifier);
        return this;
    }

    @Optional
    public FluidReg<E> noOcclusion() {
        return this.withBlockProperty(BlockBehaviour.Properties::m_60955_);
    }

    @Optional
    public FluidReg<E> noCollision() {
        return this.withBlockProperty(BlockBehaviour.Properties::m_60910_);
    }

    @Optional
    public FluidReg<E> noLoot() {
        return this.withBlockProperty(BlockBehaviour.Properties::m_222994_);
    }

    @Optional
    public FluidReg<E> noLootAndOcclusion() {
        return this.noLoot().noOcclusion();
    }

    @Optional
    public FluidReg<E> tintColor(int r, int g, int b) {
        this.tintColor = r * 255 * 255 + g * 255 + b;
        return this;
    }

    @Optional
    public FluidReg<E> tintColor(int color) {
        this.tintColor = color;
        return this;
    }

    @Optional
    public FluidReg<E> overlayTexPath(String path) {
        this.overlayTexturePath = path;
        return this;
    }

    @Optional
    public FluidReg<E> typeProperty(PropertyBuilder builder) {
        this.propertyBuilders.add(builder);
        return this;
    }

    @Mandatory
    public FluidReg<E> basicFluidProperties(int lightLevel, int density, int viscosity, boolean canSupportBoating) {
        return this.lightLevel(lightLevel).canSupportBoating(canSupportBoating).density(density).viscosity(viscosity);
    }

    public FluidReg<E> lightLevel(int lightLevel) {
        return this.typeProperty(prop -> prop.lightLevel(lightLevel));
    }

    public FluidReg<E> canSupportBoating(boolean flag) {
        return this.typeProperty(prop -> prop.supportsBoating(flag));
    }

    public FluidReg<E> density(int density) {
        return this.typeProperty(prop -> prop.density(density));
    }

    public FluidReg<E> viscosity(int viscosity) {
        return this.typeProperty(prop -> prop.viscosity(viscosity));
    }

    @Optional
    public FluidReg<E> bucketFillSound(SoundEvent sound) {
        return this.typeProperty(prop -> prop.sound(SoundActions.BUCKET_FILL, sound));
    }

    @Optional
    public FluidReg<E> bucketEmptySound(SoundEvent sound) {
        return this.typeProperty(prop -> prop.sound(SoundActions.BUCKET_EMPTY, sound));
    }

    @Optional
    public FluidReg<E> vaporizeSound(SoundEvent sound) {
        return this.typeProperty(prop -> prop.sound(SoundActions.FLUID_VAPORIZE, sound));
    }

    @Optional
    public FluidReg<E> sound(SoundAction action, SoundEvent sound) {
        return this.typeProperty(prop -> prop.sound(action, sound));
    }

    @Optional
    public FluidReg<E> sound(SoundEvent fillSound, SoundEvent emptySound, SoundEvent vaporizeSound) {
        return this.bucketFillSound(fillSound).bucketEmptySound(emptySound).vaporizeSound(vaporizeSound);
    }

    @Optional
    public FluidReg<E> blockSound(SoundType sound) {
        this.block.withSound(sound);
        return this;
    }

    @Optional
    public FluidReg<E> defaultSounds() {
        return this.sound(SoundEvents.f_11781_, SoundEvents.f_11778_, SoundEvents.f_11937_);
    }

    @Optional
    public FluidReg<E> setRenderType(String type) {
        this.renderType = type;
        return this;
    }

    @Optional
    public FluidReg<E> setTranslucentRenderType() {
        this.renderType = "translucent";
        return this;
    }

    @Optional
    public FluidReg<E> fogColor(Vector3f fogColor) {
        this.fogColor = fogColor;
        return this;
    }

    @Optional
    public FluidReg<E> fogColor(float r, float g, float b) {
        this.fogColor = new Vector3f(r / 255.0f, g / 255.0f, b / 255.0f);
        return this;
    }

    @Optional
    public FluidReg<E> fluidProperty(FluidPropertyBuilder builder) {
        this.builders.add(builder);
        return this;
    }

    @Override
    @Mandatory
    public FluidReg<E> submit(SimpleRegistry registry) {
        this.properties.descriptionId("fluid_type." + registry.namespace + "." + this.registrationKey);
        registry.cacheFluidRenderIn(this);
        this.propertyBuilders.forEach(b -> b.build(this.properties));
        if (this.flowingBuilder == null) {
            this.crashOnNotPresent(ForgeFlowingFluid.class, "flow", "submit");
        }
        if (this.stillBuilder == null) {
            this.crashOnNotPresent(ForgeFlowingFluid.class, "still", "submit");
        }
        this.block.fluid(() -> (ForgeFlowingFluid)this.stillObject.get());
        if (this.registerBlock) {
            this.block.submit(registry);
        }
        this.type = this.type == null ? this.initDefaultType(registry) : this.type;
        RegistryObject typeObj = registry.fluid_type().register(this.registrationKey, () -> this.type);
        this.fluidProp = new ForgeFlowingFluid.Properties((Supplier)typeObj, () -> (Fluid)this.stillObject.get(), () -> (Fluid)this.flowingObject.get());
        this.fluidProp.bucket(this::bucket);
        for (FluidPropertyBuilder builder : this.builders) {
            builder.build(this.fluidProp);
        }
        if (this.stillBuilder != null) {
            this.stillObject = registry.fluid().register(this.stillRegKey, () -> (ForgeFlowingFluid)this.stillBuilder.build(this.fluidProp));
        }
        if (this.flowingBuilder != null) {
            this.flowingObject = registry.fluid().register(this.flowingRegKey, () -> (ForgeFlowingFluid)this.flowingBuilder.build(this.fluidProp));
        }
        if (this.registerItem) {
            this.itemReg.submit(registry);
        }
        if (this.menuReg != null && this.registerMenu && !registry.hasMenuCache(this.toString())) {
            registry.cacheMenuIn(this.menuReg);
        }
        MinecraftForge.EVENT_BUS.addListener(this::getFillResult);
        this.tag.submit(registry);
        return this;
    }

    public RegistryObject<E> still() {
        return this.stillObject;
    }

    public RegistryObject<E> flowing() {
        return this.flowingObject;
    }

    public FluidType fluidType() {
        return this.type;
    }

    public ForgeFlowingFluid stillFluid() {
        return (ForgeFlowingFluid)this.stillObject.get();
    }

    public ForgeFlowingFluid flowingFluid() {
        return (ForgeFlowingFluid)this.flowingObject.get();
    }

    public RegistryObject<? extends BucketItem> itemRegistryObject() {
        return this.itemReg.getRegistryObject();
    }

    public BucketItem bucket() {
        return this.itemReg.getItem();
    }

    public LiquidBlock legacyBlock() {
        return this.block.getBlock();
    }

    public String getRenderType() {
        return this.renderType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderType genRenderType() {
        return NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation(this.renderType)).block();
    }

    @Override
    public String getIdentifier() {
        return "fluid";
    }

    @Inner
    private FluidType initDefaultType(SimpleRegistry registry) {
        final ResourceLocation stillLoc = this.stillTexturePath == null ? null : new ResourceLocation(registry.namespace, this.stillTexturePath);
        final ResourceLocation flowingLoc = this.flowingTexturePath == null ? null : new ResourceLocation(registry.namespace, this.flowingTexturePath);
        final ResourceLocation overlayLoc = this.overlayTexturePath == null ? null : new ResourceLocation(registry.namespace, this.overlayTexturePath);
        FluidType type = new FluidType(this.properties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public int getTintColor() {
                        return FluidReg.this.tintColor;
                    }

                    public ResourceLocation getStillTexture() {
                        if (stillLoc != null) {
                            return stillLoc;
                        }
                        return super.getStillTexture();
                    }

                    public ResourceLocation getFlowingTexture() {
                        if (flowingLoc != null) {
                            return flowingLoc;
                        }
                        return super.getFlowingTexture();
                    }

                    @Nullable
                    public ResourceLocation getOverlayTexture() {
                        if (overlayLoc != null) {
                            return overlayLoc;
                        }
                        return super.getOverlayTexture();
                    }

                    @NotNull
                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        return FluidReg.this.fogColor;
                    }

                    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                        RenderSystem.m_157445_((float)1.0f);
                        RenderSystem.m_157443_((float)6.0f);
                    }
                });
            }
        };
        return type;
    }

    @SubscribeEvent
    public ItemStack getFillResult(FillBucketEvent event) {
        if (this.customFillEvent != null) {
            return this.customFillEvent.get(event, this);
        }
        if (event.getTarget() == null || event.getTarget().m_6662_() != HitResult.Type.BLOCK) {
            return event.getEmptyBucket();
        }
        Player player = event.getEntity();
        if (!player.m_21120_(InteractionHand.MAIN_HAND).m_150930_(this.bucketSupplier.get())) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        BlockHitResult bhr = (BlockHitResult)event.getTarget();
        BlockPos pos = new BlockPos((Vec3i)bhr.m_82425_());
        BlockState state = event.getLevel().m_8055_(pos);
        if (!state.m_60713_((Block)this.block.getBlock())) {
            return event.getEmptyBucket();
        }
        LiquidBlock bp = (LiquidBlock)state.m_60734_();
        if (!bp.getFluid().m_7444_(bp.m_5888_(state))) {
            return event.getEmptyBucket();
        }
        event.setResult(Event.Result.ALLOW);
        Level level = event.getLevel();
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        ItemStack result = this.bucket().m_7968_();
        event.setFilledBucket(result);
        SoundEvent sound = this.type.getSound(SoundActions.BUCKET_FILL);
        if (sound != null) {
            level.m_5594_(player, player.m_20097_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return result;
    }

    public static interface FluidBuilder<T extends Fluid> {
        public T build(ForgeFlowingFluid.Properties var1);
    }

    public static interface CustomFillEvent {
        public ItemStack get(FillBucketEvent var1, FluidReg<?> var2);
    }

    public static interface FluidPropertyBuilder {
        public void build(ForgeFlowingFluid.Properties var1);
    }

    public static interface PropertyBuilder {
        public void build(FluidType.Properties var1);
    }

    public static interface BucketBuilder<T extends BucketItem> {
        public T build(Supplier<ForgeFlowingFluid> var1, Item.Properties var2);
    }
}

