/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.core.base.item_helper.ExternalProperties;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.common.CreativeTabReg;
import kasuga.lib.registrations.common.MenuReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ItemReg<T extends Item>
extends Reg {
    @Nullable
    public ResourceLocation model;
    private boolean customRender = false;
    private ItemBuilder<T> builder;
    public final Item.Properties properties = new ExternalProperties();
    private RegistryObject<T> registryObject = null;
    private MenuReg<?, ?> menuReg = null;
    private final List<TagKey<?>> tags;
    boolean registerMenu = false;

    public ItemReg(String registrationKey, @Nullable ResourceLocation model) {
        super(registrationKey);
        this.model = model;
        this.tags = new ArrayList();
    }

    public ItemReg(String registrationKey) {
        super(registrationKey);
        this.model = null;
        this.tags = new ArrayList();
    }

    public static ItemReg<BlockItem> defaultBlockItem(BlockReg<?> blockReg, @Nullable ResourceLocation model) {
        ItemReg<BlockItem> reg = new ItemReg<BlockItem>(blockReg.registrationKey, model);
        reg.itemType(properties1 -> new BlockItem(blockReg.getBlock(), properties1));
        return reg;
    }

    public static ItemReg<BlockItem> defaultBlockItem(BlockReg<?> blockReg) {
        ItemReg<BlockItem> reg = new ItemReg<BlockItem>(blockReg.registrationKey);
        reg.itemType(properties1 -> new BlockItem(blockReg.getBlock(), properties1));
        return reg;
    }

    @Mandatory
    public ItemReg<T> itemType(ItemBuilder<? extends Item> builder) {
        this.builder = builder;
        return this;
    }

    @Optional
    public ItemReg<T> model(ResourceLocation location) {
        this.model = location;
        return this;
    }

    @Optional
    public ItemReg<T> shouldCustomRender(boolean flag) {
        this.customRender = flag;
        return this;
    }

    @Optional
    public ItemReg<T> stackTo(int size) {
        this.properties.m_41487_(size);
        return this;
    }

    @Optional
    public ItemReg<T> tab(CreativeTabReg tab) {
        this.properties.m_41491_((CreativeModeTab)tab.getTab());
        return this;
    }

    @Optional
    public ItemReg<T> tab(CreativeModeTab tab) {
        this.properties.m_41491_(tab);
        return this;
    }

    @Optional
    public <F extends AbstractContainerMenu, U extends Screen> ItemReg<T> withMenu(String registrationKey, IContainerFactory<?> menu, Supplier<MenuReg.FullScreenInvoker<F, U>> screen) {
        this.menuReg = new MenuReg(registrationKey).withMenuAndScreen(menu, screen);
        this.registerMenu = true;
        return this;
    }

    @Optional
    public ItemReg<T> withMenu(MenuReg<?, ?> menuReg) {
        this.menuReg = menuReg;
        this.registerMenu = false;
        return this;
    }

    @Optional
    public ItemReg<T> withTag(TagKey<Item> tag) {
        this.tags.add(tag);
        return this;
    }

    @Optional
    public ItemReg<T> withProperty(PropertyIdentifier identifier) {
        identifier.apply(this.properties);
        return this;
    }

    @Override
    @Mandatory
    public ItemReg<T> submit(SimpleRegistry registry) {
        if (this.builder == null) {
            this.crashOnNotPresent(Item.class, "itemType", "submit");
        }
        if (this.model != null) {
            registry.modelMappings().addMapping(new ResourceLocation(registry.namespace, "item/" + this.registrationKey + ".json"), this.model);
        }
        if (this.customRender) {
            registry.stackCustomRenderedItemIn(this.registrationKey);
        }
        this.registryObject = registry.item().register(this.registrationKey, () -> this.builder.build(this.properties));
        if (this.menuReg != null && this.registerMenu && !registry.hasMenuCache(this.toString())) {
            registry.cacheMenuIn(this.menuReg);
        }
        return this;
    }

    public T getItem() {
        return (T)(this.registryObject == null ? null : (Item)this.registryObject.get());
    }

    public RegistryObject<T> getRegistryObject() {
        return this.registryObject;
    }

    public ResourceLocation getModelLocation() {
        return this.model;
    }

    ItemBuilder<T> type() {
        return this.builder;
    }

    @Override
    public String getIdentifier() {
        return "item";
    }

    public static interface ItemBuilder<T extends Item> {
        public T build(Item.Properties var1);
    }

    public static interface PropertyIdentifier {
        public void apply(Item.Properties var1);
    }
}

