/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.function.Supplier;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.RegistryObject;

public class MenuReg<T extends AbstractContainerMenu, U extends Screen>
extends Reg {
    private IContainerFactory<T> menuFactory;
    private Supplier<FullScreenInvoker<T, U>> screenFactory;
    private RegistryObject<MenuType<T>> registryObject = null;

    public MenuReg(String registrationKey) {
        super(registrationKey);
    }

    @Optional
    public MenuReg<T, U> withMenuAndScreen(IContainerFactory<T> menu, Supplier<FullScreenInvoker<T, U>> screen) {
        this.menuFactory = menu;
        this.screenFactory = screen;
        return this;
    }

    @Override
    @Mandatory
    public MenuReg<T, U> submit(SimpleRegistry registry) {
        registry.cacheMenuIn(this);
        if (this.menuFactory == null) {
            this.crashOnNotPresent(IContainerFactory.class, "withMenuAndScreen", "submit");
        }
        if (this.screenFactory == null) {
            this.crashOnNotPresent(Screen.class, "withMenuAndScreen", "submit");
        }
        if (this.registryObject != null) {
            return this;
        }
        this.registryObject = registry.menus().register(this.registrationKey, () -> IForgeMenuType.create(this.menuFactory));
        return this;
    }

    public RegistryObject<MenuType<T>> getRegistryObject() {
        return this.registryObject;
    }

    public MenuType<T> getMenuType() {
        if (this.registryObject == null) {
            return null;
        }
        return (MenuType)this.registryObject.get();
    }

    @Override
    public String getIdentifier() {
        return "menu";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void hookMenuAndScreen() {
        MenuScreens.m_96206_((MenuType)((MenuType)this.registryObject.get()), this.screenFactory.get().getConstructor());
    }

    public static interface FullScreenInvoker<T extends AbstractContainerMenu, U extends Screen> {
        public U invoke(T var1, Inventory var2, Component var3);

        @OnlyIn(value=Dist.CLIENT)
        default public MenuScreens.ScreenConstructor<T, U> getConstructor() {
            return this::invoke;
        }
    }

    public static interface ScreenInvoker<U extends Screen> {
        public U invoke(Component var1);
    }
}

