/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.function.Supplier;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.ConfiguredFeatureReg;
import kasuga.lib.registrations.common.PlacedFeatureReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class OreReg<T extends Block>
extends Reg {
    private Supplier<T> oreBlockSupplier;
    private final ConfiguredFeatureReg<T> configuredFeatureObject;
    private final PlacedFeatureReg placedFeatureObject;

    public OreReg(String registrationKey) {
        super(registrationKey);
        this.configuredFeatureObject = new ConfiguredFeatureReg(registrationKey);
        this.placedFeatureObject = new PlacedFeatureReg(registrationKey);
    }

    @Mandatory
    public OreReg<T> setOreBlock(Supplier<T> oreBlockSupplier) {
        this.oreBlockSupplier = oreBlockSupplier;
        return this;
    }

    public OreReg<T> addOreBlockReplaceTarget(ResourceLocation block) {
        this.configuredFeatureObject.addOreConfigTargetByBlock(block, this.oreBlockSupplier);
        return this;
    }

    public OreReg<T> addOreTagReplaceTarget(TagKey<Block> tagKey) {
        this.configuredFeatureObject.addOreConfigTargetByKey(tagKey, this.oreBlockSupplier);
        return this;
    }

    public OreReg<T> addOreRuleReplaceTarget(RuleTest ruleTest) {
        this.configuredFeatureObject.addOreConfigTargetByRule(ruleTest, this.oreBlockSupplier);
        return this;
    }

    public OreReg<T> addOreReplaceTarget() {
        this.configuredFeatureObject.addOreConfigTarget(this.oreBlockSupplier);
        return this;
    }

    public OreReg<T> addDeepSlateReplaceTarget() {
        this.configuredFeatureObject.addDeepSlateOreConfigTarget(this.oreBlockSupplier);
        return this;
    }

    public OreReg<T> setOreQuantityPerGroup(int count) {
        count = Math.max(1, Math.min(count, 64));
        this.configuredFeatureObject.setQuantityPerGroup(count);
        return this;
    }

    public OreReg<T> setOreAnchorAbove(int maxHeight, int minHeight) {
        this.placedFeatureObject.setVerticalAnchorAbove(maxHeight, minHeight);
        return this;
    }

    public OreReg<T> setOreAnchorAbsolute(int maxHeight, int minHeight) {
        this.placedFeatureObject.setVerticalAnchorAbsolute(maxHeight, minHeight);
        return this;
    }

    public OreReg<T> setOreDistributionType(PlacedFeatureReg.DistributionType distributionType) {
        this.placedFeatureObject.setDistributionType(distributionType);
        return this;
    }

    public OreReg<T> setOreCountPerChunk(int count) {
        this.placedFeatureObject.setGroupCountPerChunk(count);
        return this;
    }

    @Override
    public OreReg<T> submit(SimpleRegistry registry) {
        if (this.configuredFeatureObject == null) {
            this.crashOnNotPresent(ConfiguredFeatureReg.class, "OrgReg", "submit");
            return this;
        }
        if (this.placedFeatureObject == null) {
            this.crashOnNotPresent(PlacedFeatureReg.class, "OrgReg", "submit");
            return this;
        }
        this.configuredFeatureObject.submit(registry);
        this.placedFeatureObject.setConfiguredFeatureObject(this.configuredFeatureObject.getRegistryObject()).submit(registry);
        return this;
    }

    @Override
    public String getIdentifier() {
        return "ore";
    }
}

