/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.List;
import javax.annotation.Nullable;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.core.Holder;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.RegistryObject;

public class PlacedFeatureReg
extends Reg {
    private int groupCountPerChunk = 10;
    private Pair<Integer, Integer> verticalAnchorAbove = null;
    private Pair<Integer, Integer> verticalAnchorAbsolute = null;
    private DistributionType distributionType = DistributionType.TRIANGLE;
    private RegistryObject<ConfiguredFeature<?, ?>> configuredFeatureObject = null;
    private HeightRangePlacement heightRangePlacement = null;
    private RegistryObject<PlacedFeature> object = null;

    public PlacedFeatureReg(String registrationKey) {
        super(registrationKey);
    }

    public PlacedFeatureReg setVerticalAnchorAbove(int maxHeight, int minHeight) {
        this.verticalAnchorAbove = Pair.of(maxHeight, minHeight);
        return this;
    }

    public PlacedFeatureReg setVerticalAnchorAbsolute(int maxHeight, int minHeight) {
        this.verticalAnchorAbsolute = Pair.of(maxHeight, minHeight);
        return this;
    }

    public PlacedFeatureReg setDistributionType(DistributionType distributionType) {
        this.distributionType = distributionType;
        return this;
    }

    public PlacedFeatureReg setGroupCountPerChunk(int count) {
        this.groupCountPerChunk = count;
        return this;
    }

    public PlacedFeatureReg setConfiguredFeatureObject(RegistryObject<ConfiguredFeature<?, ?>> configuredFeature) {
        this.configuredFeatureObject = configuredFeature;
        return this;
    }

    @Override
    public PlacedFeatureReg submit(SimpleRegistry registry) {
        if (this.verticalAnchorAbove == null && this.verticalAnchorAbsolute == null) {
            KasugaLib.MAIN_LOGGER.error("In PlacedFeatureReg", (Throwable)new NullPointerException("Neither above nor absolute vertical has been set!"));
            this.crashOnNotPresent(Integer.class, "PlacedFeature", "submit");
            return this;
        }
        VerticalAnchor verticalAnchorTop = null;
        VerticalAnchor verticalAnchorBottom = null;
        if (this.verticalAnchorAbove != null) {
            verticalAnchorTop = VerticalAnchor.m_158930_((int)this.verticalAnchorAbove.getFirst());
            verticalAnchorBottom = VerticalAnchor.m_158930_((int)this.verticalAnchorAbove.getSecond());
        } else {
            verticalAnchorTop = VerticalAnchor.m_158922_((int)this.verticalAnchorAbsolute.getFirst());
            verticalAnchorBottom = VerticalAnchor.m_158922_((int)this.verticalAnchorAbsolute.getSecond());
        }
        this.heightRangePlacement = this.distributionType == DistributionType.TRIANGLE ? HeightRangePlacement.m_191692_((VerticalAnchor)verticalAnchorBottom, (VerticalAnchor)verticalAnchorTop) : HeightRangePlacement.m_191680_((VerticalAnchor)verticalAnchorBottom, (VerticalAnchor)verticalAnchorTop);
        this.object = registry.placedFeature().register(this.registrationKey, () -> new PlacedFeature((Holder)this.configuredFeatureObject.getHolder().get(), PlacedFeatureReg.commonOrePlacement(this.groupCountPerChunk, (PlacementModifier)this.heightRangePlacement)));
        return this;
    }

    @Nullable
    public RegistryObject<PlacedFeature> getRegisterObject() {
        return this.object;
    }

    @Override
    public String getIdentifier() {
        return "placed_feature";
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier1, PlacementModifier modifier2) {
        return List.of(modifier1, InSquarePlacement.m_191715_(), modifier2, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier2) {
        return PlacedFeatureReg.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier2);
    }

    private static List<PlacementModifier> rareOrePlacement(int chance, PlacementModifier modifier2) {
        return PlacedFeatureReg.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)chance), modifier2);
    }

    public static enum DistributionType {
        UNIFORM,
        TRIANGLE;

    }
}

