/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;

public class RecipeReg<T extends Recipe<?>, F extends RecipeSerializer<?>>
extends Reg {
    public F recipeSerializer;
    public RegistryObject<RecipeType<T>> recipeRegistryObject = null;
    public RegistryObject<F> recipeSerializerRegistryObject = null;

    public RecipeReg(String registrationKey) {
        super(registrationKey);
    }

    public RecipeReg(String registrationKey, RecipeSerializer<?> serializer) {
        this(registrationKey);
        this.withSerializer(serializer);
    }

    @Override
    @Mandatory
    public RecipeReg<T, F> submit(SimpleRegistry registry) {
        if (this.recipeSerializer == null) {
            this.crashOnNotPresent(RecipeSerializer.class, "recipeSerializer", "submit");
        }
        this.recipeRegistryObject = registry.recipe().register(this.registrationKey, () -> new RecipeType<T>(){

            public String toString() {
                return RecipeReg.this.registrationKey;
            }
        });
        this.recipeSerializerRegistryObject = registry.recipe_serializer().register(this.registrationKey, () -> this.recipeSerializer);
        return this;
    }

    public F getSerializer() {
        return (F)(this.recipeSerializerRegistryObject == null ? null : (RecipeSerializer)this.recipeSerializerRegistryObject.get());
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeRegistryObject == null ? null : (RecipeType)this.recipeRegistryObject.get();
    }

    public RecipeReg<T, F> withSerializer(RecipeSerializer<?> serializer) {
        this.recipeSerializer = serializer;
        return this;
    }

    @Override
    public String getIdentifier() {
        return "recipe";
    }
}

