/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.create;

import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import kasuga.lib.core.create.BlockStateGenerator;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.create.BogeySizeReg;
import kasuga.lib.registrations.registry.CreateRegistry;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class BogeyBlockReg<T extends AbstractBogeyBlock<?>>
extends Reg {
    private final List<BlockReg.PropertyIdentifier> identifiers;
    private BogeyBlockBuilder<T> builder = null;
    private Material material = Material.f_76296_;
    private NonNullSupplier<BogeySizes.BogeySize> size = null;
    private MaterialColor color = MaterialColor.f_76398_;
    private BlockStateGenerator<T> stateGenerator = null;
    private String langKey = "";
    private BlockEntry<T> entry = null;

    public BogeyBlockReg(String registrationKey) {
        super(registrationKey);
        this.identifiers = new ArrayList<BlockReg.PropertyIdentifier>();
    }

    public BogeyBlockReg<T> block(BogeyBlockBuilder<T> builder) {
        this.builder = builder;
        return this;
    }

    public BogeyBlockReg<T> material(Material material) {
        this.material = material;
        return this;
    }

    public BogeyBlockReg<T> materialColor(MaterialColor color) {
        this.color = color;
        return this;
    }

    public BogeyBlockReg<T> translationKey(String key) {
        this.langKey = key;
        return this;
    }

    public BogeyBlockReg<T> size(NonNullSupplier<BogeySizes.BogeySize> size) {
        this.size = size;
        return this;
    }

    public BogeyBlockReg<T> size(BogeySizeReg sizeReg) {
        this.size = sizeReg::getSize;
        return this;
    }

    public BogeyBlockReg<T> transform(BlockStateGenerator<T> generator) {
        this.stateGenerator = generator;
        return this;
    }

    public BogeyBlockReg<T> property(BlockReg.PropertyIdentifier identifier) {
        this.identifiers.add(identifier);
        return this;
    }

    public BogeyBlockReg<T> noOcclusion() {
        this.identifiers.add(BlockBehaviour.Properties::m_60955_);
        return this;
    }

    @Override
    public BogeyBlockReg<T> submit(SimpleRegistry registry) {
        if (!(registry instanceof CreateRegistry)) {
            return this;
        }
        CreateRegistry createRegistry = (CreateRegistry)registry;
        BlockBuilder blockBuilder = createRegistry.createRegistry().block(this.registrationKey, p -> this.builder.get((BlockBehaviour.Properties)p, (BogeySizes.BogeySize)this.size.get())).initialProperties(this.material).properties(p -> p.m_155949_(this.color));
        if (this.stateGenerator != null) {
            blockBuilder.transform(this.stateGenerator.build());
        }
        blockBuilder.lang(this.langKey).properties(BlockBehaviour.Properties::m_60955_);
        this.identifiers.forEach(i -> blockBuilder.properties(p -> {
            i.apply((BlockBehaviour.Properties)p);
            return p;
        }));
        this.entry = blockBuilder.register();
        return this;
    }

    public BlockEntry<T> getEntry() {
        return this.entry;
    }

    @Override
    public String getIdentifier() {
        return "bogey_block";
    }

    public static interface BogeyBlockBuilder<T extends AbstractBogeyBlock<?>> {
        public T get(BlockBehaviour.Properties var1, BogeySizes.BogeySize var2);
    }
}

