/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.create;

import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.create.BogeyBlockReg;
import kasuga.lib.registrations.create.BogeySizeReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BogeyGroupReg
extends Reg {
    Component translationName = null;
    private final List<BogeyStyleBuilderContext> contexts;
    private NonNullSupplier<BogeyRenderer> defaultRenderer = null;
    private String cycleGroup = "";
    private ParticleOptions contactParticle = null;
    private ParticleOptions smokeParticle = null;
    private BogeyStyle style = null;

    public BogeyGroupReg(String registrationKey, String cycleGroup) {
        super(registrationKey);
        this.cycleGroup = cycleGroup;
        this.contexts = new ArrayList<BogeyStyleBuilderContext>();
    }

    public BogeyGroupReg translationKey(String key) {
        this.translationName = Component.m_237115_((String)key);
        return this;
    }

    public BogeyGroupReg cycleGroup(String group) {
        this.cycleGroup = group;
        return this;
    }

    public BogeyGroupReg defaultRenderer(NonNullSupplier<BogeyRenderer> renderer) {
        this.defaultRenderer = renderer;
        return this;
    }

    public BogeyGroupReg bogeyWithDefaultRenderer(BogeySizes.BogeySize size, ResourceLocation id) {
        this.contexts.add(new BogeyStyleBuilderContext(size, (Supplier<BogeyRenderer>)this.defaultRenderer, id));
        return this;
    }

    public BogeyGroupReg bogeyWithDefaultRenderer(BogeySizes.BogeySize size, String namespace, BogeyBlockReg<?> reg) {
        this.contexts.add(new BogeyStyleBuilderContext(size, (Supplier<BogeyRenderer>)this.defaultRenderer, new ResourceLocation(namespace, reg.registrationKey)));
        return this;
    }

    public BogeyGroupReg bogey(BogeySizes.BogeySize size, Supplier<BogeyRenderer> renderer, ResourceLocation id) {
        this.contexts.add(new BogeyStyleBuilderContext(size, renderer, id));
        return this;
    }

    public BogeyGroupReg bogey(BogeySizes.BogeySize size, Supplier<BogeyRenderer> rendererSupplier, String namespace, BogeyBlockReg<?> reg) {
        this.contexts.add(new BogeyStyleBuilderContext(size, rendererSupplier, new ResourceLocation(namespace, reg.registrationKey)));
        return this;
    }

    public BogeyGroupReg bogey(BogeySizeReg size, Supplier<BogeyRenderer> rendererSupplier, ResourceLocation id) {
        this.contexts.add(new BogeyStyleBuilderContext(size.getSize(), rendererSupplier, id));
        return this;
    }

    public BogeyGroupReg bogey(BogeySizeReg size, Supplier<BogeyRenderer> rendererSupplier, String namespace, BogeyBlockReg<?> reg) {
        this.contexts.add(new BogeyStyleBuilderContext(size.getSize(), rendererSupplier, new ResourceLocation(namespace, reg.registrationKey)));
        return this;
    }

    @Override
    public BogeyGroupReg submit(SimpleRegistry registry) {
        AllBogeyStyles.BogeyStyleBuilder builder = new AllBogeyStyles.BogeyStyleBuilder(registry.asResource(this.registrationKey), registry.asResource(this.cycleGroup));
        if (this.translationName != null) {
            builder.displayName(this.translationName);
        }
        if (this.contactParticle != null) {
            builder.contactParticle(this.contactParticle);
        }
        if (this.smokeParticle != null) {
            builder.smokeParticle(this.smokeParticle);
        }
        for (BogeyStyleBuilderContext context : this.contexts) {
            ResourceLocation location = new ResourceLocation(context.id.m_135827_().equals("") ? registry.namespace : context.id.m_135827_(), context.id.m_135815_());
            builder.size(context.size, () -> context.supplier, location);
        }
        this.style = builder.build();
        return this;
    }

    public BogeyStyle getStyle() {
        return this.style;
    }

    @Override
    public String getIdentifier() {
        return "bogey_group";
    }

    public record BogeyStyleBuilderContext(BogeySizes.BogeySize size, Supplier<BogeyRenderer> supplier, ResourceLocation id) {
    }
}

