/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.create;

import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackModel;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kasuga.lib.core.create.TrackStateGenerator;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.common.CreativeTabReg;
import kasuga.lib.registrations.registry.CreateRegistry;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public class TrackReg<T extends TrackBlock>
extends BlockReg<T> {
    private BlockEntry<T> entry;
    private Supplier<TrackMaterial> trackMaterialSupplier;
    private List<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
    private NonNullSupplier<CreativeModeTab> tabSupplier;
    private TrackStateGenerator.Builder generator;
    private ResourceLocation trackItemModelLocation;
    int transformType = 0;
    private String trackNameSuffix = "";
    private BlockReg.BlockRendererBuilder<T> rendererBuilder;

    public TrackReg(String registrationKey) {
        super(registrationKey);
    }

    public TrackReg<T> addTags(TagKey<Block> tag) {
        this.tags.add(tag);
        return this;
    }

    public TrackReg<T> tab(NonNullSupplier<CreativeModeTab> tab) {
        this.tabSupplier = tab;
        return this;
    }

    public TrackReg<T> tab(CreativeTabReg tabReg) {
        this.tabSupplier = tabReg::getTab;
        return this;
    }

    @Override
    public TrackReg<T> material(Material material) {
        super.material(material);
        return this;
    }

    public TrackReg<T> trackMaterial(Supplier<TrackMaterial> trackMaterialSupplier) {
        this.trackMaterialSupplier = trackMaterialSupplier;
        return this;
    }

    public TrackReg<T> trackState(TrackStateGenerator.Builder builder) {
        this.generator = builder;
        return this;
    }

    public TrackReg<T> trackNameSuffix(String suffix) {
        this.trackNameSuffix = suffix;
        return this;
    }

    public TrackReg<T> pickaxeOnly() {
        this.transformType = 0;
        return this;
    }

    public TrackReg<T> axeOnly() {
        this.transformType = 1;
        return this;
    }

    public TrackReg<T> axeOrPickaxe() {
        this.transformType = 2;
        return this;
    }

    @Override
    public TrackReg<T> withBlockRenderer(BlockReg.BlockRendererBuilder<T> builder) {
        this.rendererBuilder = builder;
        return this;
    }

    @Override
    public TrackReg<T> submit(SimpleRegistry registry) {
        if (!(registry instanceof CreateRegistry)) {
            return this;
        }
        CreateRegistry createRegistry = (CreateRegistry)registry;
        this.initProperties();
        CreateRegistrate registrate = createRegistry.createRegistry();
        if (this.tabSupplier != null) {
            registrate = (CreateRegistrate)registrate.creativeModeTab(this.tabSupplier);
        }
        TrackMaterial material = this.trackMaterialSupplier.get();
        BlockBuilder builder = registrate.block(this.registrationKey, arg_0 -> ((TrackMaterial)material).createBlock(arg_0)).initialProperties(this.material);
        switch (this.transformType) {
            case 1: {
                builder.transform(TagGen.axeOnly());
                break;
            }
            case 2: {
                builder.transform(TagGen.axeOrPickaxe());
                break;
            }
            default: {
                builder.transform(TagGen.pickaxeOnly());
            }
        }
        builder.blockstate((arg_0, arg_1) -> ((TrackStateGenerator)this.generator.build()).generate(arg_0, arg_1)).lang(material.langName + this.trackNameSuffix).properties(BlockBehaviour.Properties::m_60955_);
        this.tags.forEach(xva$0 -> builder.tag(new TagKey[]{xva$0}));
        ((BlockBuilder)builder.onRegister(CreateRegistrate.blockModel(() -> TrackModel::new))).item(TrackBlockItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{this.trackItemModelLocation})).build();
        this.entry = builder.register();
        if (this.rendererBuilder != null) {
            registry.cacheBlockRendererIn(this, this.rendererBuilder);
        }
        return this;
    }

    public BlockEntry<T> getEntry() {
        return this.entry;
    }

    public T getTrackBlock() {
        return (T)((TrackBlock)this.entry.get());
    }

    public Item getTrackItem() {
        return ((TrackBlock)this.entry.get()).m_5456_();
    }

    @Override
    public T getBlock() {
        return (T)((TrackBlock)this.getEntry().get());
    }

    @Override
    public String getIdentifier() {
        return "track";
    }
}

