/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.compute.data.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kasuga.lib.vendor_modules.interpreter.compute.data.Line;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.exceptions.FormulaSynatxError;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Assignable;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Pretreatable;

public abstract class Function
implements Formula,
Assignable,
Pretreatable {
    final String codec;
    public final List<Formula> params;
    final Namespace namespace;
    boolean flip = false;
    public static final String DOTS = ",";

    public Function(String codec, Namespace namespace) {
        this.codec = codec;
        this.params = new ArrayList<Formula>();
        this.namespace = namespace;
    }

    public Function(String codec, Namespace namespace, List<Formula> params) {
        this.codec = codec;
        this.params = params;
        this.namespace = namespace;
    }

    public Function(String codec, Namespace namespace, Formula ... params) {
        this.codec = codec;
        this.params = new ArrayList<Formula>(List.of(params));
        this.namespace = namespace;
    }

    public Function(String codec, Namespace namespace, String paramString) {
        this(codec, namespace);
        this.fromString(paramString);
    }

    public String getCodec() {
        return this.codec;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder();
        if (this.flip) {
            builder.append("-");
        }
        builder.append(this.codec).append("(");
        if (this.params.size() == 1) {
            builder.append(this.params.get(0).getString());
        } else {
            for (Formula formula : this.params) {
                if (this.params.indexOf(formula) == this.params.size() - 1) {
                    builder.append(formula.getString());
                    continue;
                }
                builder.append(formula.getString()).append(", ");
            }
        }
        return builder.append(")").toString();
    }

    public int paramListLength() {
        return this.params.size();
    }

    @Override
    public String getIdentifier() {
        return "function";
    }

    @Override
    public float getResult() {
        return this.flip ? -this.operate() : this.operate();
    }

    public abstract float operate();

    @Override
    public List<Formula> getElements() {
        return List.of(this);
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean shouldRemove() {
        return false;
    }

    @Override
    public void flipOutput(boolean flip) {
        this.flip = flip;
    }

    @Override
    public boolean isOutputFlipped() {
        return this.flip;
    }

    @Override
    public void fromString(String string) {
        String str = string.replaceAll(" ", "");
        Integer[] dots = this.getAllDots(string);
        if (dots.length == 0) {
            this.addParamsFromLine(new Line(str, this.namespace));
        } else if (dots.length == 1) {
            if (dots[0] == str.length() - 1) {
                throw new FormulaSynatxError(this, dots[0]);
            }
            String front = string.substring(0, dots[0]);
            String back = string.substring(dots[0] + 1);
            this.addParamsFromLine(new Line(front, this.namespace));
            this.addParamsFromLine(new Line(back, this.namespace));
        } else {
            String param = string.substring(0, dots[0]);
            this.addParamsFromLine(new Line(param, this.namespace));
            for (int i = 0; i < dots.length - 1; ++i) {
                param = string.substring(dots[i] + 1, dots[i + 1]);
                this.addParamsFromLine(new Line(param, this.namespace));
            }
            param = string.substring(dots[dots.length - 1] + 1);
            this.addParamsFromLine(new Line(param, this.namespace));
        }
    }

    void addParamsFromLine(Line line) {
        if (line.isAtomic() && !line.shouldRemove()) {
            this.params.add(line.getElements().get(0));
        } else if (!line.shouldRemove()) {
            this.params.add(line);
        }
    }

    Integer[] getAllDots(String paramString) {
        if (!paramString.contains(DOTS)) {
            return new Integer[0];
        }
        int counter = 0;
        char dots = DOTS.charAt(0);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < paramString.length(); ++i) {
            char regex = paramString.charAt(i);
            if (regex == '(') {
                ++counter;
                continue;
            }
            if (regex == ')') {
                --counter;
                continue;
            }
            if (regex != dots || counter != 0) continue;
            result.add(i);
        }
        return result.toArray(new Integer[0]);
    }

    @Override
    public abstract Function clone();

    public abstract Function clone(Namespace var1);

    @Override
    public Set<String> variableCodecs() {
        return this.namespace.instanceNames();
    }

    @Override
    public void assign(String codec, float value) {
        if (this.namespace.containsInstance(codec)) {
            this.namespace.getInstance(codec).assign(codec, value);
        }
    }

    @Override
    public boolean containsVar(String codec) {
        return this.namespace.containsInstance(codec);
    }

    @Override
    public float getValue(String codec) {
        if (!this.containsVar(codec)) {
            throw new FormulaSynatxError(this, 0);
        }
        return this.namespace.getInstance(codec).getValue(codec);
    }

    @Override
    public boolean hasVar() {
        return this.namespace.instanceVarSize() > 0;
    }

    @Override
    public void preTreatment() {
        for (Formula formula : this.params) {
            if (!(formula instanceof Pretreatable)) continue;
            Pretreatable pretreatable = (Pretreatable)((Object)formula);
            pretreatable.preTreatment();
        }
    }

    public List<Formula> getParams() {
        return this.params;
    }

    public int paramCount() {
        return this.params.size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Function)) {
            return false;
        }
        Function function = (Function)obj;
        return function.toString().equals(this.toString());
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }
}

