/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.logic.operations;

import kasuga.lib.vendor_modules.interpreter.logic.data.LogicalNumeric;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalData;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalOperator;
import kasuga.lib.vendor_modules.interpreter.logic.operations.MathType;

public class MathOperation
implements LogicalData,
LogicalOperator {
    private final MathType type;

    public MathOperation(MathType type) {
        this.type = type;
    }

    public MathOperation(String type) {
        this.type = MathType.fromString(type);
    }

    @Override
    public boolean operate(LogicalData former, LogicalData rear) {
        LogicalNumeric numeric1;
        block13: {
            block12: {
                if (!(former instanceof LogicalNumeric)) break block12;
                numeric1 = (LogicalNumeric)former;
                if (rear instanceof LogicalNumeric) break block13;
            }
            if (this.type == MathType.EQUALS) {
                return former.getResult() == rear.getResult();
            }
            throw new RuntimeException();
        }
        LogicalNumeric numeric2 = (LogicalNumeric)rear;
        switch (this.type) {
            case EQUALS: {
                return numeric1.mathResult() == numeric2.mathResult();
            }
            case LARGER: {
                return numeric1.mathResult() > numeric2.mathResult();
            }
            case SMALLER: {
                return numeric1.mathResult() < numeric2.mathResult();
            }
            case LARGER_EQU: {
                return numeric1.mathResult() >= numeric2.mathResult();
            }
            case SMALLER_EQU: {
                return numeric1.mathResult() <= numeric2.mathResult();
            }
            case NOT_EQU: {
                return numeric1.mathResult() != numeric2.mathResult();
            }
        }
        return false;
    }

    public static boolean isMathOperation(String mathFlag) {
        return MathType.fromString(mathFlag.replace(" ", "")) != MathType.INVALID;
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public boolean getResult() {
        return false;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public MathOperation clone() {
        return new MathOperation(this.type);
    }

    @Override
    public boolean is(Object type) {
        if (type instanceof MathType) {
            return type == this.type;
        }
        return false;
    }
}

