/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.org.apache.http.impl.cookie;

import java.util.Date;
import kasuga.lib.vendor_modules.org.apache.http.annotation.Contract;
import kasuga.lib.vendor_modules.org.apache.http.annotation.ThreadingBehavior;
import kasuga.lib.vendor_modules.org.apache.http.cookie.CommonCookieAttributeHandler;
import kasuga.lib.vendor_modules.org.apache.http.cookie.MalformedCookieException;
import kasuga.lib.vendor_modules.org.apache.http.cookie.SetCookie;
import kasuga.lib.vendor_modules.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import kasuga.lib.vendor_modules.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + value);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

