/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.org.apache.http.impl.cookie;

import kasuga.lib.vendor_modules.org.apache.http.annotation.Contract;
import kasuga.lib.vendor_modules.org.apache.http.annotation.ThreadingBehavior;
import kasuga.lib.vendor_modules.org.apache.http.cookie.CommonCookieAttributeHandler;
import kasuga.lib.vendor_modules.org.apache.http.cookie.Cookie;
import kasuga.lib.vendor_modules.org.apache.http.cookie.CookieOrigin;
import kasuga.lib.vendor_modules.org.apache.http.cookie.MalformedCookieException;
import kasuga.lib.vendor_modules.org.apache.http.cookie.SetCookie;
import kasuga.lib.vendor_modules.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import kasuga.lib.vendor_modules.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

