/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kasuga.lib.vendor_modules.org.apache.commons.logging.Log;
import kasuga.lib.vendor_modules.org.apache.commons.logging.LogFactory;
import kasuga.lib.vendor_modules.org.apache.http.ConnectionReuseStrategy;
import kasuga.lib.vendor_modules.org.apache.http.HttpClientConnection;
import kasuga.lib.vendor_modules.org.apache.http.HttpEntity;
import kasuga.lib.vendor_modules.org.apache.http.HttpException;
import kasuga.lib.vendor_modules.org.apache.http.HttpHost;
import kasuga.lib.vendor_modules.org.apache.http.HttpRequest;
import kasuga.lib.vendor_modules.org.apache.http.HttpResponse;
import kasuga.lib.vendor_modules.org.apache.http.ProtocolException;
import kasuga.lib.vendor_modules.org.apache.http.annotation.Contract;
import kasuga.lib.vendor_modules.org.apache.http.annotation.ThreadingBehavior;
import kasuga.lib.vendor_modules.org.apache.http.client.config.RequestConfig;
import kasuga.lib.vendor_modules.org.apache.http.client.methods.CloseableHttpResponse;
import kasuga.lib.vendor_modules.org.apache.http.client.methods.HttpExecutionAware;
import kasuga.lib.vendor_modules.org.apache.http.client.methods.HttpRequestWrapper;
import kasuga.lib.vendor_modules.org.apache.http.client.methods.HttpUriRequest;
import kasuga.lib.vendor_modules.org.apache.http.client.protocol.HttpClientContext;
import kasuga.lib.vendor_modules.org.apache.http.client.protocol.RequestClientConnControl;
import kasuga.lib.vendor_modules.org.apache.http.client.utils.URIUtils;
import kasuga.lib.vendor_modules.org.apache.http.conn.ConnectionKeepAliveStrategy;
import kasuga.lib.vendor_modules.org.apache.http.conn.ConnectionRequest;
import kasuga.lib.vendor_modules.org.apache.http.conn.HttpClientConnectionManager;
import kasuga.lib.vendor_modules.org.apache.http.conn.routing.HttpRoute;
import kasuga.lib.vendor_modules.org.apache.http.impl.conn.ConnectionShutdownException;
import kasuga.lib.vendor_modules.org.apache.http.impl.execchain.ClientExecChain;
import kasuga.lib.vendor_modules.org.apache.http.impl.execchain.ConnectionHolder;
import kasuga.lib.vendor_modules.org.apache.http.impl.execchain.HttpResponseProxy;
import kasuga.lib.vendor_modules.org.apache.http.impl.execchain.RequestAbortedException;
import kasuga.lib.vendor_modules.org.apache.http.protocol.HttpContext;
import kasuga.lib.vendor_modules.org.apache.http.protocol.HttpProcessor;
import kasuga.lib.vendor_modules.org.apache.http.protocol.HttpRequestExecutor;
import kasuga.lib.vendor_modules.org.apache.http.protocol.ImmutableHttpProcessor;
import kasuga.lib.vendor_modules.org.apache.http.protocol.RequestContent;
import kasuga.lib.vendor_modules.org.apache.http.protocol.RequestTargetHost;
import kasuga.lib.vendor_modules.org.apache.http.protocol.RequestUserAgent;
import kasuga.lib.vendor_modules.org.apache.http.util.Args;
import kasuga.lib.vendor_modules.org.apache.http.util.VersionInfo;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class MinimalClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor httpProcessor;

    public MinimalClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(connManager, "Client connection manager");
        Args.notNull(reuseStrategy, "Connection reuse strategy");
        Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpClient", "kasuga.lib.vendor_modules.org.apache.http.client", this.getClass())));
        this.requestExecutor = requestExecutor;
        this.connManager = connManager;
        this.reuseStrategy = reuseStrategy;
        this.keepAliveStrategy = keepAliveStrategy;
    }

    static void rewriteRequestURI(HttpRequestWrapper request, HttpRoute route, boolean normalizeUri) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (uri != null) {
                uri = uri.isAbsolute() ? URIUtils.rewriteURI(uri, null, normalizeUri ? URIUtils.DROP_FRAGMENT_AND_NORMALIZE : URIUtils.DROP_FRAGMENT) : URIUtils.rewriteURI(uri);
                request.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), ex);
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpClientConnection managedConn;
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        MinimalClientExec.rewriteRequestURI(request, route, context.getRequestConfig().isNormalizeUri());
        ConnectionRequest connRequest = this.connManager.requestConnection(route, null);
        if (execAware != null) {
            if (execAware.isAborted()) {
                connRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            execAware.setCancellable(connRequest);
        }
        RequestConfig config = context.getRequestConfig();
        try {
            int timeout = config.getConnectionRequestTimeout();
            managedConn = connRequest.get(timeout > 0 ? (long)timeout : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            throw new RequestAbortedException("Request execution failed", cause);
        }
        ConnectionHolder releaseTrigger = new ConnectionHolder(this.log, this.connManager, managedConn);
        try {
            URI uri;
            int timeout;
            if (execAware != null) {
                if (execAware.isAborted()) {
                    releaseTrigger.close();
                    throw new RequestAbortedException("Request aborted");
                }
                execAware.setCancellable(releaseTrigger);
            }
            if (!managedConn.isOpen()) {
                timeout = config.getConnectTimeout();
                this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, context);
                this.connManager.routeComplete(managedConn, route, context);
            }
            if ((timeout = config.getSocketTimeout()) >= 0) {
                managedConn.setSocketTimeout(timeout);
            }
            HttpHost target = null;
            HttpRequest original = request.getOriginal();
            if (original instanceof HttpUriRequest && (uri = ((HttpUriRequest)original).getURI()).isAbsolute()) {
                target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            }
            if (target == null) {
                target = route.getTargetHost();
            }
            context.setAttribute("http.target_host", target);
            context.setAttribute("http.request", request);
            context.setAttribute("http.connection", managedConn);
            context.setAttribute("http.route", route);
            this.httpProcessor.process(request, (HttpContext)context);
            HttpResponse response = this.requestExecutor.execute(request, managedConn, context);
            this.httpProcessor.process(response, (HttpContext)context);
            if (this.reuseStrategy.keepAlive(response, context)) {
                long duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                releaseTrigger.setValidFor(duration, TimeUnit.MILLISECONDS);
                releaseTrigger.markReusable();
            } else {
                releaseTrigger.markNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                releaseTrigger.releaseConnection();
                return new HttpResponseProxy(response, null);
            }
            return new HttpResponseProxy(response, releaseTrigger);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            throw ioex;
        }
        catch (HttpException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (Error error) {
            this.connManager.shutdown();
            throw error;
        }
    }
}

