/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.org.apache.http.protocol;

import java.io.IOException;
import kasuga.lib.vendor_modules.org.apache.http.HttpEntityEnclosingRequest;
import kasuga.lib.vendor_modules.org.apache.http.HttpException;
import kasuga.lib.vendor_modules.org.apache.http.HttpRequest;
import kasuga.lib.vendor_modules.org.apache.http.HttpRequestInterceptor;
import kasuga.lib.vendor_modules.org.apache.http.annotation.Contract;
import kasuga.lib.vendor_modules.org.apache.http.annotation.ThreadingBehavior;
import kasuga.lib.vendor_modules.org.apache.http.protocol.HttpContext;
import kasuga.lib.vendor_modules.org.apache.http.protocol.HttpDateGenerator;
import kasuga.lib.vendor_modules.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

