/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import kasuga.lib.vendor_modules.org.apache.http.HttpConnection;
import kasuga.lib.vendor_modules.org.apache.http.HttpException;
import kasuga.lib.vendor_modules.org.apache.http.HttpHost;
import kasuga.lib.vendor_modules.org.apache.http.HttpInetConnection;
import kasuga.lib.vendor_modules.org.apache.http.HttpRequest;
import kasuga.lib.vendor_modules.org.apache.http.HttpRequestInterceptor;
import kasuga.lib.vendor_modules.org.apache.http.HttpVersion;
import kasuga.lib.vendor_modules.org.apache.http.ProtocolException;
import kasuga.lib.vendor_modules.org.apache.http.ProtocolVersion;
import kasuga.lib.vendor_modules.org.apache.http.annotation.Contract;
import kasuga.lib.vendor_modules.org.apache.http.annotation.ThreadingBehavior;
import kasuga.lib.vendor_modules.org.apache.http.protocol.HttpContext;
import kasuga.lib.vendor_modules.org.apache.http.protocol.HttpCoreContext;
import kasuga.lib.vendor_modules.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

