/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kasuga.lib.core.client.animation.Constants;
import kasuga.lib.core.client.animation.data.anchor.Anchor;
import kasuga.lib.core.client.animation.data.anchor.AnchorsGroup;
import kasuga.lib.core.client.animation.data.bones.BonesGroup;
import kasuga.lib.core.client.animation.data.timer.TimeLineGroup;
import kasuga.lib.core.client.animation.data.trigger.TriggerGroup;
import kasuga.lib.core.client.animation.infrastructure.IAnchor;
import kasuga.lib.core.client.animation.infrastructure.MappingLayer;
import kasuga.lib.core.client.render.PoseContext;
import kasuga.lib.core.client.render.model.SimpleModel;
import kasuga.lib.core.util.Resources;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Animation {
    private final String key;
    private final ResourceLocation location;
    private final Namespace namespace;
    private final MappingLayer mappingLayer;
    private final TriggerGroup triggerGroup;
    private final TimeLineGroup timeLineGroup;
    private final BonesGroup bonesGroup;
    private final AnchorsGroup anchorsGroup;

    public Animation(String name, Namespace namespace, ResourceLocation location) {
        this.key = name;
        this.location = location;
        this.namespace = namespace;
        this.mappingLayer = new MappingLayer();
        this.mappingLayer.buildMapping();
        this.triggerGroup = new TriggerGroup(namespace);
        this.timeLineGroup = new TimeLineGroup(namespace);
        this.bonesGroup = new BonesGroup(this, namespace);
        this.anchorsGroup = new AnchorsGroup(this, namespace);
    }

    public void decode(JsonObject root) {
        if (root.has("anchor")) {
            this.anchorsGroup.decodeAnchors(root.getAsJsonObject("anchor"));
        }
        if (root.has("trigger")) {
            this.triggerGroup.decode(root.getAsJsonObject("trigger"));
        }
        if (root.has("timer")) {
            this.timeLineGroup.decode(root.getAsJsonObject("timer"));
        }
        if (root.has("actor")) {
            this.bonesGroup.decodeBones(root.getAsJsonObject("actor"));
        }
        this.init();
    }

    public static Map<String, Animation> decode(Namespace namespace, ResourceLocation location) throws IOException {
        Resource resources = Resources.getResource(location);
        JsonObject fileRoot = JsonParser.parseReader((JsonReader)new JsonReader((Reader)resources.m_215508_())).getAsJsonObject();
        if (!fileRoot.has("animation")) {
            return new HashMap<String, Animation>();
        }
        HashMap<String, Animation> result = new HashMap<String, Animation>();
        JsonObject root = fileRoot.getAsJsonObject("animation");
        for (Map.Entry entry : root.entrySet()) {
            Animation animation = new Animation((String)entry.getKey(), namespace, location);
            animation.decode(((JsonElement)entry.getValue()).getAsJsonObject());
            result.put((String)entry.getKey(), animation);
        }
        return result;
    }

    public SimpleModel getModel() {
        return this.mappingLayer.getModel();
    }

    public static Optional<Animation> decode(Namespace namespace, ResourceLocation location, String name) {
        try {
            Map<String, Animation> map = Animation.decode(namespace, location);
            if (map.containsKey(name)) {
                return Optional.of(map.get(name));
            }
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<Animation> decode(ResourceLocation location, String name) {
        try {
            Map<String, Animation> map = Animation.decode(Constants.root().clone(), location);
            if (map.containsKey(name)) {
                return Optional.of(map.get(name));
            }
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public void init() {
        this.triggerGroup.init();
        this.timeLineGroup.init();
        this.bonesGroup.init();
        this.anchorsGroup.init();
        Constants.stackAnimateIn(this);
    }

    public void action() {
        this.triggerGroup.action();
        this.timeLineGroup.action();
        for (Map.Entry<String, SimpleModel> entry : this.mappingLayer.getMapping().entrySet()) {
            String key = entry.getKey();
            SimpleModel model = entry.getValue();
            if (!this.bonesGroup.containsMovements(key)) continue;
            for (PoseContext.Action action : this.bonesGroup.getMovement(key).getAllActions()) {
                model.addAction(action);
            }
        }
    }

    public void tick() {
        this.timeLineGroup.tick();
    }

    public void assign(String codec, float value) {
        this.namespace.assign(codec, value);
    }

    public void assign(Entity entity, float partial) {
        this.assign("x", (float)entity.m_20182_().m_7096_());
        this.assign("y", (float)entity.m_20182_().m_7098_());
        this.assign("z", (float)entity.m_20182_().m_7094_());
        this.assign("x_rot", entity.m_146909_());
        this.assign("y_rot", entity.m_146908_());
        this.assign("time", (float)entity.m_9236_().m_46468_());
        this.assign("tick", (float)Constants.tick());
        this.assign("partial", partial);
    }

    public BonesGroup getBonesGroup() {
        return this.bonesGroup;
    }

    public boolean containsBoneMovement(String key) {
        return this.bonesGroup.containsMovements(key);
    }

    public AnchorsGroup getAnchors() {
        return this.anchorsGroup;
    }

    public boolean containsAnchor(String key) {
        return this.anchorsGroup.containsAnchor(key);
    }

    public boolean containsAsAnchor(String codec) {
        return this.containsAnchor(codec) || this.containsBoneMovement(codec);
    }

    public IAnchor getAsAnchor(String codec) {
        if (this.containsAnchor(codec)) {
            return this.anchorsGroup.getAnchor(codec);
        }
        if (this.containsBoneMovement(codec)) {
            return this.bonesGroup.getMovement(codec);
        }
        return new Anchor(this, this.namespace, "invalid");
    }

    public void assign(BlockEntity tile, float partial) {
        this.assign("x", (float)tile.m_58899_().m_123341_());
        this.assign("y", (float)tile.m_58899_().m_123342_());
        this.assign("z", (float)tile.m_58899_().m_123343_());
        if (tile.m_58900_().m_61138_((Property)BlockStateProperties.f_61372_)) {
            this.assign("x_rot", -((Direction)tile.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_().m_122435_());
        } else {
            this.assign("x_rot", 0.0f);
        }
        this.assign("y_rot", 0.0f);
        if (tile.m_58898_()) {
            this.assign("time", (float)tile.m_58904_().m_46468_());
        } else {
            this.assign("time", 0.0f);
        }
        this.assign("tick", (float)Constants.tick());
        this.assign("partial", partial);
    }

    public void loadModel(SimpleModel model) {
        this.mappingLayer.rebuildMapping(model);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public String getName() {
        return this.key;
    }

    public Animation clone() {
        return Animation.decode(this.location, this.key).orElse(null);
    }
}

