/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.data.timer;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.animation.infrastructure.AnimAssignable;
import kasuga.lib.core.client.animation.infrastructure.AnimationElement;
import kasuga.lib.core.client.animation.infrastructure.Condition;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.data.Numeric;
import kasuga.lib.vendor_modules.interpreter.compute.data.Variable;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import kasuga.lib.vendor_modules.interpreter.logic.data.LogicalBool;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TimeLine
extends AnimationElement
implements AnimAssignable {
    Formula max;
    Formula min;
    Formula org;
    private final HashMap<Condition, Formula> chasers;
    private final HashMap<Condition, Formula> tickingChasers;
    private final HashMap<Condition, ArrayList<String>> controlledElements = new HashMap();
    private final HashMap<Condition, ArrayList<String>> tickingControlledElements;
    private final Namespace namespace;
    Condition condition;

    public TimeLine(String key, Namespace namespace) {
        super(key);
        this.chasers = new HashMap();
        this.tickingChasers = new HashMap();
        this.tickingControlledElements = new HashMap();
        this.namespace = namespace;
    }

    @Override
    public void init() {
        this.namespace.assign(this.key(), this.org.getResult());
    }

    public static TimeLine decode(String key, Namespace namespace, JsonObject object) {
        LogicalData data = LogicalBool.defaultTrue();
        if (object.has("condition")) {
            String element = object.get("condition").getAsString();
            data = element.equals("true") || element.equals("false") ? new LogicalBool(element.equals("true")) : namespace.decodeLogical(element);
        }
        TimeLine timeLine = new TimeLine(key, namespace);
        Condition condition = new Condition("condition", namespace, data);
        Formula max = timeLine.createFormula(object, "max", 100.0f);
        Formula min = timeLine.createFormula(object, "min", 0.0f);
        Formula org = timeLine.createFormula(object, "org", 0.0f);
        namespace.registerInstance(key, new Variable(key + ".max", namespace, max.getResult()));
        namespace.registerInstance(key, new Variable(key + ".min", namespace, min.getResult()));
        namespace.registerInstance(key, new Variable(key + ".org", namespace, org.getResult()));
        namespace.registerInstance(key, new Variable(key, namespace, 0.0f));
        timeLine.getChasers(object, namespace, false);
        timeLine.getChasers(object, namespace, true);
        timeLine.condition = condition;
        timeLine.max = max;
        timeLine.min = min;
        timeLine.org = org;
        return timeLine;
    }

    private void getChasers(JsonObject object, Namespace namespace, boolean ticking) {
        String name;
        String string = name = ticking ? "ticking" : "chaser";
        if (object.has(name)) {
            Pair<HashMap<Condition, Formula>, HashMap<Condition, ArrayList<String>>> maps = TimeLine.getMapFromJson(namespace, object.get(name));
            if (ticking) {
                this.tickingChasers.putAll((Map<Condition, Formula>)maps.getFirst());
                this.tickingControlledElements.putAll((Map<Condition, ArrayList<String>>)maps.getSecond());
            } else {
                this.chasers.putAll((Map<Condition, Formula>)maps.getFirst());
                this.controlledElements.putAll((Map<Condition, ArrayList<String>>)maps.getSecond());
            }
        }
    }

    public static Pair<HashMap<Condition, Formula>, HashMap<Condition, ArrayList<String>>> getMapFromJson(Namespace namespace, JsonElement members) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map m = (Map)KasugaLib.GSON.fromJson(members, type);
        HashMap<Condition, Formula> result = new HashMap<Condition, Formula>();
        HashMap<Condition, ArrayList<String>> controlledElements = new HashMap<Condition, ArrayList<String>>();
        for (String con : m.keySet()) {
            String string = (String)m.get(con);
            String[] spt = string.split("=");
            Condition condition1 = new Condition("condition", namespace, namespace.decodeLogical(con));
            if (spt.length == 2) {
                String[] vars = spt[0].replace(" ", "").split(",");
                Formula formula = namespace.decodeFormula(spt[1]);
                result.put(condition1, formula);
                controlledElements.put(condition1, new ArrayList<String>(List.of(vars)));
                for (String var : vars) {
                    if (namespace.containsInstance(var)) continue;
                    namespace.registerInstance(var, new Variable(var, namespace, formula.getResult()));
                }
                continue;
            }
            if (spt.length != 1) continue;
            result.put(condition1, namespace.decodeFormula(spt[0]));
        }
        return Pair.of(result, controlledElements);
    }

    private Formula createFormula(JsonObject parentObject, String key, float defaultValue) {
        if (!parentObject.has(key)) {
            return new Numeric(defaultValue);
        }
        return this.createFormula(parentObject.get(key), defaultValue);
    }

    private Formula createFormula(JsonElement jsonObject, float defaultValue) {
        Formula result = new Numeric(defaultValue);
        try {
            result = new Numeric(jsonObject.getAsNumber().floatValue());
        }
        catch (ClassCastException e) {
            result = this.namespace.decodeFormula(jsonObject.getAsString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void action() {
        this.innerAction(this.chasers, this.controlledElements);
    }

    public void actionTicking() {
        this.innerAction(this.tickingChasers, this.tickingControlledElements);
    }

    private void innerAction(HashMap<Condition, Formula> chaser, HashMap<Condition, ArrayList<String>> controlled) {
        for (Condition condition : chaser.keySet()) {
            if (!condition.result()) continue;
            float[] values = this.updateValues();
            float result = chaser.get(condition).getResult();
            float value = Math.max(Math.min(values[0], result), values[1]);
            for (String var : controlled.get(condition)) {
                if (var.equals(this.key())) {
                    this.namespace.assign(var, value);
                    continue;
                }
                this.namespace.assign(var, result);
            }
        }
    }

    public float[] updateValues() {
        float max = this.getMax().getResult();
        float min = this.getMin().getResult();
        float org = this.getOrg().getResult();
        this.namespace.assign(this.key() + ".max", max);
        this.namespace.assign(this.key() + ".min", min);
        this.namespace.assign(this.key() + ".org", org);
        return new float[]{max, min, org};
    }

    public void setCondition(String condition) {
        this.condition = new Condition(this.key(), this.namespace, condition);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setMax(String max) {
        this.max = this.namespace.decodeFormula(max);
    }

    public Formula getMax() {
        return this.max;
    }

    public void setMin(String min) {
        this.min = this.namespace.decodeFormula(min);
    }

    public Formula getMin() {
        return this.min;
    }

    public void setOrg(String org) {
        this.org = this.namespace.decodeFormula(org);
    }

    public Formula getOrg() {
        return this.org;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    public void addChaser(String condition, String varsAndChaser) {
        String[] strs = varsAndChaser.replace(" ", "").split("=");
        if (strs.length == 2) {
            String[] vars = strs[0].split(",");
            this.addChaser(condition, strs[1], vars);
        }
    }

    public void addChaser(String condition, String chaser, String ... controlled) {
        Formula formula = this.namespace.decodeFormula(chaser);
        Condition cond = new Condition(this.key(), this.namespace, condition);
        this.controlledElements.put(cond, new ArrayList<String>(List.of(controlled)));
        this.addChaser(cond, formula);
    }

    private void addChaser(Condition condition, Formula formula) {
        this.chasers.put(condition, formula);
    }

    public void removeChaser(Condition condition) {
        this.chasers.remove(condition);
    }

    public void removeChaser(int index) {
        this.chasers.remove(index);
    }

    @Nullable
    public Pair<Condition, Formula> getChaser(Condition condition) {
        if (this.chasers.containsKey(condition)) {
            return Pair.of(condition, this.chasers.get(condition));
        }
        return null;
    }

    public Formula[] getAllActing() {
        Formula[] formulas = new Formula[this.chasers.size()];
        int counter = 0;
        Iterator<Formula> iterator = this.chasers.values().iterator();
        while (iterator.hasNext()) {
            Formula formula;
            formulas[counter] = formula = iterator.next();
            ++counter;
        }
        return formulas;
    }

    public HashMap<Condition, Formula> getChasers() {
        return this.chasers;
    }

    @Override
    public boolean isValid() {
        return this.max != null && this.min != null && this.org != null && !this.chasers.isEmpty() && this.condition != null;
    }

    @Override
    public void assign(String codec, float value) {
        this.namespace.assign(codec, value);
    }

    @Override
    public boolean isAssignable() {
        return this.isValid() && this.namespace.hasInstance();
    }
}

