/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public class VectorIOUtil {
    public static void writeVec3ToJson(JsonObject json, String name, Vec3 vec) {
        JsonObject obj = new JsonObject();
        obj.addProperty("x", (Number)vec.m_7096_());
        obj.addProperty("y", (Number)vec.m_7098_());
        obj.addProperty("z", (Number)vec.m_7094_());
        json.add(name, (JsonElement)obj);
    }

    public static Vec3 readVec3FromJson(JsonObject json, String name) {
        if (!json.has(name)) {
            return Vec3.f_82478_;
        }
        JsonElement element = json.get(name);
        if (!(element instanceof JsonObject)) {
            return Vec3.f_82478_;
        }
        JsonObject obj = (JsonObject)element;
        double x = obj.get("x").getAsDouble();
        double y = obj.get("y").getAsDouble();
        double z = obj.get("z").getAsDouble();
        return new Vec3(x, y, z);
    }

    public static void writeVec3ListToJson(JsonObject json, String name, List<Vec3> vec3s) {
        if (vec3s.isEmpty()) {
            return;
        }
        int size = vec3s.size();
        JsonObject obj = new JsonObject();
        obj.addProperty("size", (Number)size);
        for (int i = 0; i < size; ++i) {
            VectorIOUtil.writeVec3ToJson(obj, String.valueOf(i), vec3s.get(i));
        }
        json.add(name, (JsonElement)obj);
    }

    public static List<Vec3> readVec3ListFromJson(JsonObject json, String name) {
        if (!json.has(name)) {
            return List.of();
        }
        JsonElement element = json.get(name);
        if (!(element instanceof JsonObject)) {
            return List.of();
        }
        JsonObject obj = (JsonObject)element;
        int size = obj.get("size").getAsInt();
        ArrayList<Vec3> result = new ArrayList<Vec3>(size);
        for (int i = 0; i < size; ++i) {
            result.add(VectorIOUtil.readVec3FromJson(obj, String.valueOf(i)));
        }
        return result;
    }

    public static void writeVec3ToNbt(CompoundTag nbt, String name, Vec3 vec3) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", "vec3");
        tag.m_128347_("x", vec3.m_7096_());
        tag.m_128347_("y", vec3.m_7098_());
        tag.m_128347_("z", vec3.m_7094_());
        nbt.m_128365_(name, (Tag)tag);
    }

    public static Vec3 getVec3FromNbt(CompoundTag nbt, String name) {
        if (!nbt.m_128441_(name)) {
            return Vec3.f_82478_;
        }
        CompoundTag tag = nbt.m_128469_(name);
        if (tag.m_128440_() != 4) {
            return Vec3.f_82478_;
        }
        String type = tag.m_128461_("type");
        if (!type.equals("vec3")) {
            return Vec3.f_82478_;
        }
        return new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
    }

    public static void writeVec3ListToNbt(CompoundTag nbt, String name, List<Vec3> vec3s) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", "vec3_list");
        tag.m_128405_("size", vec3s.size());
        int counter = 0;
        for (Vec3 vec3 : vec3s) {
            VectorIOUtil.writeVec3ToNbt(tag, String.valueOf(counter), vec3);
            ++counter;
        }
        nbt.m_128365_(name, (Tag)tag);
    }

    public static List<Vec3> getVec3ListFromNbt(CompoundTag nbt, String name) {
        if (!nbt.m_128441_(name)) {
            return List.of();
        }
        CompoundTag tag = nbt.m_128469_(name);
        if (!tag.m_128461_("type").equals("vec3_list")) {
            return List.of();
        }
        if (tag.m_128451_("size") == 0) {
            return List.of();
        }
        ArrayList<Vec3> result = new ArrayList<Vec3>(tag.m_128451_("size"));
        for (int i = 0; i < tag.m_128451_("size"); ++i) {
            result.add(VectorIOUtil.getVec3FromNbt(tag, String.valueOf(i)));
        }
        return result;
    }
}

