/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.base;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import kasuga.lib.core.base.NbtSerializable;
import kasuga.lib.core.client.animation.neo_neo.VectorIOUtil;
import kasuga.lib.core.client.animation.neo_neo.point.PivotPoint;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public abstract class Movement
implements NbtSerializable {
    protected float startTime;
    protected float endTime;
    protected Vec3 data;

    public Movement(Vec3 data, float startTime, float endTime) {
        this.data = data;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public void setStartTime(float startTime) {
        this.startTime = startTime;
    }

    public void setData(Vec3 data) {
        this.data = data;
    }

    public void setEndTime(float endTime) {
        this.endTime = endTime;
    }

    public Vec3 getData() {
        return this.data;
    }

    public float getStartTime() {
        return this.startTime;
    }

    public float getEndTime() {
        return this.endTime;
    }

    public float getTime() {
        return this.endTime - this.startTime;
    }

    public float calculateTime(float time) {
        return (time - this.startTime) / this.getTime();
    }

    public abstract Vec3 getPercentage(float var1);

    public abstract void move(float var1, PoseStack var2);

    public void reset() {
        this.data = Vec3.f_82478_;
    }

    public abstract void apply(PivotPoint var1, float var2);

    @Override
    public void write(CompoundTag nbt) {
        VectorIOUtil.writeVec3ToNbt(nbt, "data", this.data);
        nbt.m_128350_("start_time", this.startTime);
        nbt.m_128350_("end_time", this.endTime);
    }

    @Override
    public void read(CompoundTag nbt) {
        this.setData(VectorIOUtil.getVec3FromNbt(nbt, "data"));
        this.setStartTime(nbt.m_128457_("start_time"));
        this.setEndTime(nbt.m_128457_("end_time"));
    }

    public void writeJson(JsonObject json) {
    }

    public void readJson(JsonObject json) {
    }

    public void readAdditionalData(CompoundTag nbt) {
    }

    public void writeAdditionalData(CompoundTag nbt) {
    }
}

