/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.canvas;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.GameRenderer;

public class DrawTool {
    public static void drawLine(float x1, float y1, float x2, float y2, float lineWidth, BiConsumer<VertexConsumer, Integer> vertexProperty) {
        float deltaX = x2 - x1;
        float deltaY = y2 - y1;
        float length = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        if (length == 0.0f) {
            return;
        }
        float kX = deltaY / length;
        float kY = -deltaX / length;
        float rightUpX = x1 + kX * lineWidth;
        float rightUpY = y1 + kY * lineWidth;
        float rightDownX = x2 + kX * lineWidth;
        float rightDownY = y2 + kY * lineWidth;
        float leftDownX = x1 - kX * lineWidth;
        float leftDownY = y1 - kY * lineWidth;
        float leftUpX = x2 - kX * lineWidth;
        float leftUpY = y2 - kY * lineWidth;
        DrawTool.drawTetragon(rightUpX, rightUpY, rightDownX, rightDownY, leftDownX, leftDownY, leftUpX, leftUpY, vertexProperty);
    }

    public static void drawRect(float x, float y, float width, float height, BiConsumer<VertexConsumer, Integer> vertexProperty) {
        DrawTool.drawTetragon(x, y, x + width, y, x + width, y + height, x, y + height, vertexProperty);
    }

    public static void drawTetragon(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, BiConsumer<VertexConsumer, Integer> vertexProperty) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69478_();
        BufferBuilder vertexConsumer = Tesselator.m_85913_().m_85915_();
        vertexConsumer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexConsumer.m_5483_((double)x1, (double)y1, 0.0).m_5752_();
        vertexProperty.accept((VertexConsumer)vertexConsumer, 0);
        vertexConsumer.m_5752_();
        vertexConsumer.m_5483_((double)x2, (double)y2, 0.0).m_5752_();
        vertexProperty.accept((VertexConsumer)vertexConsumer, 1);
        vertexConsumer.m_5752_();
        vertexConsumer.m_5483_((double)x3, (double)y3, 0.0).m_5752_();
        vertexProperty.accept((VertexConsumer)vertexConsumer, 2);
        vertexConsumer.m_5752_();
        vertexConsumer.m_5483_((double)x4, (double)y4, 0.0).m_5752_();
        vertexProperty.accept((VertexConsumer)vertexConsumer, 3);
        vertexConsumer.m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertexConsumer.m_231175_());
        RenderSystem.m_69461_();
    }
}

