/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.layout.yoga.api;

import java.util.ArrayList;
import java.util.List;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaAlign;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaDirection;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaDisplay;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaEdge;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaFlexDirection;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaJustify;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaMeasureFunction;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaMeasureFunctionTransformer;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaNodeType;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaOverflow;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaPositionType;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaWrap;
import org.lwjgl.util.yoga.Yoga;

public class YogaNode
implements AutoCloseable {
    public static int MEMORY_LEAK_CHECK = 0;
    private long pointer;
    private final List<YogaNode> children = new ArrayList<YogaNode>(4);
    protected YogaNode owner;
    private boolean hasMeasureFunc;

    YogaNode(long pointer) {
        this.pointer = pointer;
    }

    public static YogaNode create() {
        ++MEMORY_LEAK_CHECK;
        long pointer = Yoga.YGNodeNew();
        return new YogaNode(pointer);
    }

    public static YogaNode fromPointer(long pointer) {
        return new YogaNode(pointer);
    }

    public void reset() {
        Yoga.YGNodeReset(this.pointer);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int indexOf(YogaNode node) {
        return this.children.indexOf(node);
    }

    public YogaNode getChildAt(int i) {
        return this.children.get(i);
    }

    public void addChildAt(int i, YogaNode node) {
        if (node.owner != null) {
            throw new IllegalStateException("Child already has a parent, it must be removed first.");
        }
        this.children.add(i, node);
        node.owner = this;
        Yoga.YGNodeInsertChild((long)this.pointer, (long)node.pointer, (int)i);
    }

    public void setIsReferenceBaseline(boolean isReferenceBaseline) {
        Yoga.YGNodeSetIsReferenceBaseline(this.pointer, isReferenceBaseline);
    }

    public boolean isReferenceBaseline() {
        return Yoga.YGNodeIsReferenceBaseline(this.pointer);
    }

    public void swapChildAt(YogaNode newChild, int position) {
        this.children.remove(position);
        this.children.add(position, newChild);
        newChild.owner = this;
        Yoga.YGNodeSwapChild((long)this.pointer, (long)newChild.pointer, (int)position);
    }

    public void clearChildren() {
        this.children.clear();
        Yoga.YGNodeRemoveAllChildren(this.pointer);
    }

    public void removeChildAt(int i) {
        YogaNode node = this.children.remove(i);
        if (node == null) {
            return;
        }
        node.owner = null;
        Yoga.YGNodeRemoveChild(this.pointer, node.pointer);
    }

    public void removeChild(YogaNode node) {
        node.owner = null;
        if (!this.children.contains(node)) {
            return;
        }
        this.removeChildAt(this.children.indexOf(node));
    }

    public YogaNode getOwner() {
        return this.owner;
    }

    @Deprecated
    public YogaNode getParent() {
        return this.getOwner();
    }

    public void calculateLayout(float width, float height) {
        Yoga.YGNodeCalculateLayout(this.pointer, width, height, 0);
    }

    public void dirty() {
        if (this.owner == null || !this.hasMeasureFunc) {
            return;
        }
        Yoga.YGNodeMarkDirty(this.pointer);
    }

    public void dirtyAllDescendants() {
        Yoga.YGNodeMarkDirtyAndPropogateToDescendants((long)this.pointer);
    }

    public boolean isDirty() {
        return Yoga.YGNodeIsDirty(this.pointer);
    }

    public void setDirection(YogaDirection direction) {
        Yoga.YGNodeStyleSetDirection(this.pointer, direction.getValue());
    }

    public void setJustifyContent(YogaJustify justifyContent) {
        Yoga.YGNodeStyleSetJustifyContent(this.pointer, justifyContent.getValue());
    }

    public void setAlignItems(YogaAlign alignItems) {
        Yoga.YGNodeStyleSetAlignItems(this.pointer, alignItems.getValue());
    }

    public void setAlignSelf(YogaAlign alignSelf) {
        Yoga.YGNodeStyleSetAlignSelf(this.pointer, alignSelf.getValue());
    }

    public void setAlignContent(YogaAlign alignContent) {
        Yoga.YGNodeStyleSetAlignContent(this.pointer, alignContent.getValue());
    }

    public void setPositionType(YogaPositionType type) {
        Yoga.YGNodeStyleSetPositionType(this.pointer, type.getValue());
    }

    public void setWrap(YogaWrap flexWrap) {
        Yoga.YGNodeStyleSetFlexWrap(this.pointer, flexWrap.getValue());
    }

    public void setOverflow(YogaOverflow overflow) {
        Yoga.YGNodeStyleSetOverflow(this.pointer, overflow.getValue());
    }

    public void setDisplay(YogaDisplay display) {
        Yoga.YGNodeStyleSetDisplay(this.pointer, display.getValue());
    }

    public void setFlex(float flexGrow) {
        Yoga.YGNodeStyleSetFlex(this.pointer, flexGrow);
    }

    public void setFlexGrow(float flexGrow) {
        Yoga.YGNodeStyleSetFlexGrow(this.pointer, flexGrow);
    }

    public void setFlexShrink(float flexShrink) {
        Yoga.YGNodeStyleSetFlexShrink(this.pointer, flexShrink);
    }

    public void setFlexBasis(float flexBasis) {
        Yoga.YGNodeStyleSetFlexBasis(this.pointer, flexBasis);
    }

    public void setFlexBasisPercent(float flexPercent) {
        Yoga.YGNodeStyleSetFlexBasisPercent(this.pointer, flexPercent);
    }

    public void setFlexBasisAuto() {
        Yoga.YGNodeStyleSetFlexBasisAuto(this.pointer);
    }

    public void setMargin(YogaEdge edge, float margin) {
        Yoga.YGNodeStyleSetMargin(this.pointer, edge.getValue(), margin);
    }

    public void setMarginPercent(YogaEdge edge, float percent) {
        Yoga.YGNodeStyleSetMarginPercent(this.pointer, edge.getValue(), percent);
    }

    public void setMarginAuto(YogaEdge edge) {
        Yoga.YGNodeStyleSetMarginAuto(this.pointer, edge.getValue());
    }

    public void setPadding(YogaEdge edge, float padding) {
        Yoga.YGNodeStyleSetPadding(this.pointer, edge.getValue(), padding);
    }

    public void setPaddingPercent(YogaEdge edge, float percent) {
        Yoga.YGNodeStyleSetPaddingPercent(this.pointer, edge.getValue(), percent);
    }

    public float getBorder(YogaEdge edge) {
        return Yoga.YGNodeStyleGetBorder(this.pointer, edge.getValue());
    }

    public void setBorder(YogaEdge edge, float border) {
        Yoga.YGNodeStyleSetBorder(this.pointer, edge.getValue(), border);
    }

    public void setMinWidth(float minWidth) {
        Yoga.YGNodeStyleSetMinWidth(this.pointer, minWidth);
    }

    public void setMinWidthPercent(float percent) {
        Yoga.YGNodeStyleSetMinWidthPercent(this.pointer, percent);
    }

    public void setMinHeight(float minHeight) {
        Yoga.YGNodeStyleSetMinHeight(this.pointer, minHeight);
    }

    public void setMinHeightPercent(float percent) {
        Yoga.YGNodeStyleSetMinHeightPercent(this.pointer, percent);
    }

    public void setMaxWidthPercent(float percent) {
        Yoga.YGNodeStyleSetMaxWidthPercent(this.pointer, percent);
    }

    public void setMaxHeightPercent(float percent) {
        Yoga.YGNodeStyleSetMaxHeightPercent(this.pointer, percent);
    }

    public float getAspectRatio() {
        return Yoga.YGNodeStyleGetAspectRatio(this.pointer);
    }

    public void setAspectRatio(float aspectRatio) {
        Yoga.YGNodeStyleSetAspectRatio(this.pointer, aspectRatio);
    }

    public void setWidth(float width) {
        Yoga.YGNodeStyleSetWidth(this.pointer, width);
    }

    public void setHeight(float height) {
        Yoga.YGNodeStyleSetHeight(this.pointer, height);
    }

    public void setWidthPercent(float percent) {
        Yoga.YGNodeStyleSetWidthPercent(this.pointer, percent);
    }

    public void setHeightPercent(float percent) {
        Yoga.YGNodeStyleSetHeightPercent(this.pointer, percent);
    }

    public void setWidthAuto() {
        Yoga.YGNodeStyleSetWidthAuto(this.pointer);
    }

    public void setHeightAuto() {
        Yoga.YGNodeStyleSetHeightAuto(this.pointer);
    }

    public void setMaxWidth(float maxWidth) {
        Yoga.YGNodeStyleSetMaxWidth(this.pointer, maxWidth);
    }

    public void setMaxHeight(float maxHeight) {
        Yoga.YGNodeStyleSetMaxHeight(this.pointer, maxHeight);
    }

    public void setMaxWidthPercentage(float maxWidthPercentage) {
        Yoga.YGNodeStyleSetMaxWidthPercent(this.pointer, maxWidthPercentage);
    }

    public void setMaxHeightPercentage(float maxHeightPercentage) {
        Yoga.YGNodeStyleSetMaxHeightPercent(this.pointer, maxHeightPercentage);
    }

    public void setMeasureFunction(YogaMeasureFunction measureFunction) {
        Yoga.YGNodeSetMeasureFunc(this.pointer, YogaMeasureFunctionTransformer.transform(measureFunction));
        this.hasMeasureFunc = true;
    }

    public void removeMeasureFunction() {
        Yoga.YGNodeSetMeasureFunc(this.pointer, null);
        this.hasMeasureFunc = false;
    }

    public void setPosition(YogaEdge edge, float value) {
        Yoga.YGNodeStyleSetPosition(this.pointer, edge.getValue(), value);
    }

    public void setPositionPercent(YogaEdge edge, float value) {
        Yoga.YGNodeStyleSetPositionPercent(this.pointer, edge.getValue(), value);
    }

    public void setFlexDirection(YogaFlexDirection flexDirection) {
        Yoga.YGNodeStyleSetFlexDirection(this.pointer, flexDirection.getValue());
    }

    public float getLayoutLeft() {
        return Yoga.YGNodeLayoutGetLeft(this.pointer);
    }

    public float getLayoutTop() {
        return Yoga.YGNodeLayoutGetTop(this.pointer);
    }

    public float getLayoutWidth() {
        return Yoga.YGNodeLayoutGetWidth(this.pointer);
    }

    public float getLayoutHeight() {
        return Yoga.YGNodeLayoutGetHeight(this.pointer);
    }

    public void setNodeType(YogaNodeType type) {
        Yoga.YGNodeSetNodeType(this.pointer, type.getValue());
    }

    public boolean hasNewLayout() {
        return Yoga.YGNodeGetHasNewLayout(this.pointer);
    }

    public void visited() {
        Yoga.YGNodeSetHasNewLayout(this.pointer, false);
    }

    public void free() {
        System.out.println("[GC] Yoga Node Free");
        if (this.pointer != 0L) {
            --MEMORY_LEAK_CHECK;
            long nativePointer = this.pointer;
            this.pointer = 0L;
            Yoga.YGNodeFree(nativePointer);
        }
    }

    @Override
    public void close() {
        this.free();
    }

    public void addChild(YogaNode node) {
        this.addChildAt(this.children.size(), node);
    }

    public float getLayoutMargin(YogaEdge edge) {
        return Yoga.YGNodeLayoutGetMargin(this.pointer, edge.getValue());
    }

    public float getLayoutPadding(YogaEdge edge) {
        return Yoga.YGNodeLayoutGetPadding(this.pointer, edge.getValue());
    }

    public float getLayoutBorder(YogaEdge edge) {
        return Yoga.YGNodeLayoutGetBorder(this.pointer, edge.getValue());
    }
}

