/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles.layout;

import java.util.Map;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.common.style.StyleType;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaEdge;
import kasuga.lib.core.client.frontend.gui.styles.PixelUnit;
import kasuga.lib.core.util.data_type.Pair;

public abstract class PositionStyle
extends Style<Pair<Float, PixelUnit>, StyleTarget> {
    public final String original;
    public final Pair<Float, PixelUnit> value;
    public final StyleTarget target;

    public PositionStyle(float value, PixelUnit unit) {
        this.value = Pair.of(Float.valueOf(value), unit);
        this.original = unit.toString(value);
        this.target = this.createTarget();
    }

    private StyleTarget createTarget() {
        return StyleTarget.LAYOUT_NODE.create(node -> {
            if (!this.isValid((Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>>)null)) {
                return;
            }
            switch (this.value.getSecond()) {
                case NATIVE: {
                    node.setPosition(this.getEdgeType(), this.value.getFirst().floatValue());
                    System.out.println("Apply static(" + this.getEdgeType() + " = " + this.value.getSecond().toString(this.value.getFirst().floatValue()) + ")");
                    break;
                }
                case PERCENTAGE: {
                    node.setPositionPercent(this.getEdgeType(), this.value.getFirst().floatValue());
                    System.out.println("Apply percentage(" + this.getEdgeType() + " = " + this.value.getSecond().toString(this.value.getFirst().floatValue()) + ")");
                }
            }
        });
    }

    public PositionStyle(String source) {
        this.original = source;
        this.value = PixelUnit.parse(source);
        this.target = this.createTarget();
    }

    @Override
    public boolean isValid(Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>> styles) {
        return this.value != null && this.value.getSecond() != PixelUnit.INVALID;
    }

    protected abstract YogaEdge getEdgeType();

    @Override
    public Pair<Float, PixelUnit> getValue() {
        return this.value;
    }

    @Override
    public String getValueString() {
        return this.value.getSecond().toString(this.value.getFirst().floatValue());
    }

    public static PositionStyleType createType(YogaEdge edge) {
        return new PositionStyleType(edge);
    }

    @Override
    public StyleTarget getTarget() {
        return this.target;
    }

    public static class PositionStyleType
    implements StyleType<PositionStyle, StyleTarget> {
        private final YogaEdge edgeType;
        public final PositionStyle EMPTY;

        PositionStyleType(YogaEdge edgeType) {
            this.edgeType = edgeType;
            this.EMPTY = this.create(0.0f, PixelUnit.NATIVE);
        }

        @Override
        public PositionStyle getDefault() {
            return this.EMPTY;
        }

        @Override
        public PositionStyle create(String string) {
            final PositionStyleType type = this;
            return new PositionStyle(string){

                @Override
                protected YogaEdge getEdgeType() {
                    return edgeType;
                }

                @Override
                public StyleType<?, StyleTarget> getType() {
                    return type;
                }
            };
        }

        public PositionStyle create(float value, PixelUnit unit) {
            final PositionStyleType type = this;
            return new PositionStyle(value, unit){

                @Override
                protected YogaEdge getEdgeType() {
                    return edgeType;
                }

                @Override
                public StyleType<?, StyleTarget> getType() {
                    return type;
                }
            };
        }
    }
}

