/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles.layout;

import java.util.Map;
import java.util.function.BiConsumer;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.common.style.StyleType;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaNode;
import kasuga.lib.core.client.frontend.gui.styles.PixelUnit;
import kasuga.lib.core.util.data_type.Pair;

public abstract class SizeStyle
extends Style<Pair<Float, PixelUnit>, StyleTarget> {
    public final String original;
    public final Pair<Float, PixelUnit> value;
    private StyleTarget target;

    public SizeStyle(float value, PixelUnit unit) {
        this.value = Pair.of(Float.valueOf(value), unit);
        this.original = unit.toString(value);
        this.createTarget();
    }

    public SizeStyle(String source) {
        this.original = source;
        this.value = PixelUnit.parse(source);
        this.createTarget();
    }

    @Override
    public boolean isValid(Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>> origin) {
        return this.value != null && this.value.getSecond() != PixelUnit.INVALID;
    }

    @Override
    public String getValueString() {
        return this.value.getSecond().toString(this.value.getFirst().floatValue());
    }

    @Override
    public Pair<Float, PixelUnit> getValue() {
        return this.value;
    }

    public static SizeStyleType createType(BiConsumer<YogaNode, Pair<Float, PixelUnit>> consumer) {
        return new SizeStyleType(consumer);
    }

    private void createTarget() {
        this.target = StyleTarget.LAYOUT_NODE.create(node -> {
            if (!this.isValid((Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>>)null)) {
                return;
            }
            this.getConsumer().accept((YogaNode)node, this.value);
        });
    }

    @Override
    public StyleTarget getTarget() {
        return this.target;
    }

    protected abstract BiConsumer<YogaNode, Pair<Float, PixelUnit>> getConsumer();

    public static class SizeStyleType
    implements StyleType<SizeStyle, StyleTarget> {
        private final BiConsumer<YogaNode, Pair<Float, PixelUnit>> consumer;
        public final SizeStyle EMPTY;

        SizeStyleType(BiConsumer<YogaNode, Pair<Float, PixelUnit>> accessor) {
            this.consumer = accessor;
            this.EMPTY = this.create(0.0f, PixelUnit.NATIVE);
        }

        @Override
        public SizeStyle getDefault() {
            return this.EMPTY;
        }

        @Override
        public SizeStyle create(String string) {
            final SizeStyleType type = this;
            return new SizeStyle(string){

                @Override
                public StyleType<?, StyleTarget> getType() {
                    return type;
                }

                @Override
                protected BiConsumer<YogaNode, Pair<Float, PixelUnit>> getConsumer() {
                    return consumer;
                }
            };
        }

        public SizeStyle create(float value, PixelUnit unit) {
            final SizeStyleType type = this;
            return new SizeStyle(value, unit){

                @Override
                public StyleType<?, StyleTarget> getType() {
                    return type;
                }

                @Override
                protected BiConsumer<YogaNode, Pair<Float, PixelUnit>> getConsumer() {
                    return consumer;
                }
            };
        }
    }
}

