/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles.node;

import java.util.Map;
import kasuga.lib.core.client.frontend.common.style.ResourceStyle;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.common.style.StyleType;
import kasuga.lib.core.client.frontend.gui.styles.node.SimpleNodeStyleType;
import kasuga.lib.core.client.frontend.rendering.ImageProvider;
import kasuga.lib.core.client.frontend.rendering.ImageProviders;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.resources.ResourceLocation;

public class BackgroundImageStyle
extends Style<String, StyleTarget> {
    public static final StyleType<BackgroundImageStyle, StyleTarget> TYPE = SimpleNodeStyleType.of(BackgroundImageStyle::new, "");
    public static final BackgroundImageStyle EMPTY = new BackgroundImageStyle();
    protected final String value;
    private Pair<ResourceLocation, String> location;
    ImageProvider provider;

    private BackgroundImageStyle() {
        this.value = "";
    }

    public BackgroundImageStyle(String value) {
        this.value = value;
        try {
            this.location = ResourceStyle.parse(value);
            this.provider = ImageProviders.get(this.location);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid(Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>> origin) {
        return this.location != null && this.provider != null;
    }

    @Override
    public StyleType<?, StyleTarget> getType() {
        return TYPE;
    }

    @Override
    public StyleTarget getTarget() {
        return StyleTarget.GUI_DOM_NODE.create(node -> node.getBackgroundRenderer().setImage(this.provider));
    }

    @Override
    public String getValueString() {
        return this.value;
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

