/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles.node;

import java.util.InputMismatchException;
import java.util.Map;
import java.util.Scanner;
import kasuga.lib.core.client.frontend.common.layouting.LayoutBoxI;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.common.style.StyleType;
import kasuga.lib.core.client.frontend.gui.styles.node.SimpleNodeStyleType;

public class BackgroundUVStyle
extends Style<LayoutBoxI, StyleTarget> {
    public static final StyleType<BackgroundUVStyle, StyleTarget> TYPE = SimpleNodeStyleType.of(BackgroundUVStyle::new, "0 0 0 0");
    public static final BackgroundUVStyle EMPTY = new BackgroundUVStyle();
    String uvString = "";
    boolean valid = false;
    LayoutBoxI box;

    public BackgroundUVStyle(String uv) {
        int pointer;
        int[] positions = new int[4];
        this.uvString = uv;
        try (Scanner scanner = new Scanner(uv);){
            for (pointer = 0; scanner.hasNext() && pointer < 4; ++pointer) {
                positions[pointer] = scanner.nextInt();
            }
        }
        catch (InputMismatchException mismatchException) {
            return;
        }
        if (pointer != 4) {
            return;
        }
        this.box = LayoutBoxI.of(positions[0], positions[1], positions[2], positions[3]);
        this.valid = true;
    }

    public BackgroundUVStyle() {
    }

    @Override
    public boolean isValid(Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>> origin) {
        return this.valid;
    }

    @Override
    public StyleType<?, StyleTarget> getType() {
        return TYPE;
    }

    @Override
    public StyleTarget getTarget() {
        return StyleTarget.GUI_DOM_NODE.create(node -> node.getBackgroundRenderer().setUV(this.box.x, this.box.y, this.box.width, this.box.height));
    }

    @Override
    public String getValueString() {
        return this.uvString;
    }

    @Override
    public LayoutBoxI getValue() {
        return this.box;
    }
}

