/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture.old;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import kasuga.lib.core.client.render.PoseContext;
import kasuga.lib.core.client.render.RendererUtil;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.client.render.texture.old.SimpleTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldTexture
extends SimpleTexture {
    RenderTypeBuilder builder = null;
    RenderType cachedType = null;
    PoseContext context = PoseContext.of();

    public WorldTexture(@NotNull ResourceLocation location, int uOffset, int vOffset, int uWidth, int vHeight, SimpleColor color, BufferedImage image, byte[] bytesOfImage) {
        super(location, uOffset, vOffset, uWidth, vHeight, color, image, bytesOfImage);
    }

    public WorldTexture(@NotNull ResourceLocation location, int uOffset, int vOffset, int uWidth, int vHeight, int color, float alpha) {
        super(location, uOffset, vOffset, uWidth, vHeight, color, alpha);
    }

    public WorldTexture(@NotNull ResourceLocation location, InputStream stream, int uOffset, int vOffset, int uWidth, int vHeight, int color, float alpha) {
        super(location, stream, uOffset, vOffset, uWidth, vHeight, color, alpha);
    }

    public WorldTexture(@NotNull ResourceLocation location, int uOffset, int vOffset, int uWidth, int vHeight, int color) {
        super(location, uOffset, vOffset, uWidth, vHeight, color);
    }

    public WorldTexture(@NotNull ResourceLocation location, int uOffset, int vOffset, int uWidth, int vHeight) {
        super(location, uOffset, vOffset, uWidth, vHeight);
    }

    public WorldTexture(@NotNull ResourceLocation location, int uWidth, int vHeight, int color, float alpha) {
        super(location, uWidth, vHeight, color, alpha);
    }

    public WorldTexture(@NotNull ResourceLocation location, int uWidth, int vHeight, int color) {
        super(location, uWidth, vHeight, color);
    }

    public WorldTexture(@NotNull ResourceLocation location, int uWidth, int vHeight) {
        super(location, uWidth, vHeight);
    }

    public WorldTexture(@NotNull ResourceLocation location, int color, float alpha) {
        super(location, color, alpha);
    }

    public WorldTexture(@NotNull ResourceLocation location, int color) {
        super(location, color);
    }

    public WorldTexture(@NotNull ResourceLocation location, float alpha) {
        super(location, alpha);
    }

    public WorldTexture(@NotNull ResourceLocation location) {
        super(location);
    }

    @Override
    public WorldTexture cut(int left, int up, int right, int down) {
        return new WorldTexture(this.location, this.uOffset + left, this.vOffset + up, this.uWidth - right - left, this.vHeight - down - up, this.color.getRGB(), this.color.getA());
    }

    @Override
    public WorldTexture cutSize(int left, int up, int width, int height) {
        return new WorldTexture(this.location, this.uOffset + left, this.vOffset + up, width, height, this.color, this.image, this.bytesOfImage);
    }

    @Override
    public WorldTexture flipY() {
        return new WorldTexture(this.location, this.uOffset + this.uWidth, this.vOffset, -this.uWidth, this.vHeight, this.color.getRGB(), this.color.getA());
    }

    @Override
    public WorldTexture flipX() {
        return new WorldTexture(this.location, this.uOffset, this.vOffset + this.vHeight, this.uWidth, -this.vHeight, this.color.getRGB(), this.color.getA());
    }

    public void addAction(PoseContext.Action act) {
        this.context.addAct(act);
    }

    public void translate(double x, double y, double z) {
        this.context.translate(x, -y, z);
    }

    public void scale(float x, float y, float z) {
        this.context.scale(x, y, z);
    }

    public void rotateX(float x_rotation) {
        this.context.rotateX(x_rotation);
    }

    public void rotateY(float y_rotation) {
        this.context.rotateY(y_rotation);
    }

    public void rotateZ(float z_rotation) {
        this.context.rotateZ(z_rotation);
    }

    public void lockMovement() {
        this.context.setLock(true);
    }

    public void unlockMovement() {
        this.context.setLock(false);
    }

    public boolean isMovementLocked() {
        return this.context.isLocked();
    }

    public void shouldAutoClearMovement(boolean flag) {
        this.context.setAutoClear(flag);
    }

    public boolean isAutoClearMovements() {
        return this.context.isAutoClear();
    }

    public void renderType(RenderTypeBuilder builder) {
        this.builder = builder;
    }

    public RenderType getCachedType() {
        return this.cachedType;
    }

    @Override
    public WorldTexture withColor(int color, float alpha) {
        return new WorldTexture(this.location, this.uOffset, this.vOffset, this.uWidth, this.vHeight, SimpleColor.fromRGBA(color, alpha), this.image, this.bytesOfImage);
    }

    public void turnToPlayer(@Nullable Player player, Vec3 position) {
        this.rotateY((float)RendererUtil.getVecHorizontalAngles(position, player == null ? position : player.m_146892_()));
    }

    public float getFixedHeight(float width) {
        return width / (float)this.widthHeightRatio();
    }

    public float getFixedWidth(float height) {
        return height * (float)this.widthHeightRatio();
    }

    public void render(PoseStack pose, MultiBufferSource buffer, float width, float height, int light) {
        this.render(pose, buffer, width, height, light, false);
    }

    public void render(PoseStack pose, MultiBufferSource buffer, float width, float height, int light, boolean reverse) {
        if (this.builder == null) {
            return;
        }
        if (this.cachedType == null) {
            this.cachedType = this.builder.build(this.location);
        }
        boolean shouldPush = !pose.m_85851_();
        Matrix4f lastMatrix = null;
        if (shouldPush) {
            pose.m_85836_();
        } else {
            lastMatrix = pose.m_85850_().m_85861_();
            pose.m_85849_();
            pose.m_85836_();
        }
        pose.m_85841_(1.0f, -1.0f, 1.0f);
        pose.m_85837_(0.5, 0.0, 0.5);
        this.context.apply(pose);
        Matrix4f matrix = pose.m_85850_().m_85861_();
        VertexConsumer consumer = buffer.m_6299_(this.cachedType);
        if (!reverse) {
            this.buildVertex(consumer, matrix, 0.0f, 0.0f, 0.0f, this.fuOffset, this.fvOffset, this.color, light);
            this.buildVertex(consumer, matrix, width, 0.0f, 0.0f, this.fuOffset + this.fuWidth, this.fvOffset, this.color, light);
            this.buildVertex(consumer, matrix, width, height, 0.0f, this.fuOffset + this.fuWidth, this.fvOffset + this.fvHeight, this.color, light);
            this.buildVertex(consumer, matrix, 0.0f, height, 0.0f, this.fuOffset, this.fvOffset + this.fvHeight, this.color, light);
        } else {
            this.buildVertex(consumer, matrix, 0.0f, height, 0.0f, this.fuOffset, this.fvOffset + this.fvHeight, this.color, light);
            this.buildVertex(consumer, matrix, width, height, 0.0f, this.fuOffset + this.fuWidth, this.fvOffset + this.fvHeight, this.color, light);
            this.buildVertex(consumer, matrix, width, 0.0f, 0.0f, this.fuOffset + this.fuWidth, this.fvOffset, this.color, light);
            this.buildVertex(consumer, matrix, 0.0f, 0.0f, 0.0f, this.fuOffset, this.fvOffset, this.color, light);
        }
        pose.m_85849_();
        if (!shouldPush) {
            pose.m_85836_();
            pose.m_166854_(lastMatrix);
        }
    }

    private void renderUV(PoseStack pose, MultiBufferSource buffer, int x, int y, int width, int height, float baseU, float baseV, float additionU, float additionV, int light, boolean reverse) {
        if (this.builder == null) {
            return;
        }
        if (this.cachedType == null) {
            this.cachedType = this.builder.build(this.location);
        }
        boolean shouldPush = !pose.m_85851_();
        Matrix4f lastMatrix = null;
        if (shouldPush) {
            pose.m_85836_();
        } else {
            lastMatrix = pose.m_85850_().m_85861_();
            pose.m_85849_();
            pose.m_85836_();
        }
        pose.m_85841_(1.0f, -1.0f, 1.0f);
        pose.m_85837_(0.5, 0.0, 0.5);
        this.context.apply(pose);
        Matrix4f matrix = pose.m_85850_().m_85861_();
        VertexConsumer consumer = buffer.m_6299_(this.cachedType);
        if (!reverse) {
            this.buildVertex(consumer, matrix, x, y, 0.0f, baseU, baseV, this.color, light);
            this.buildVertex(consumer, matrix, x + width, y, 0.0f, baseU + additionU, baseV, this.color, light);
            this.buildVertex(consumer, matrix, x + width, y + height, 0.0f, baseU + additionU, baseV + additionV, this.color, light);
            this.buildVertex(consumer, matrix, x, y + height, 0.0f, baseU, baseV + additionV, this.color, light);
        } else {
            this.buildVertex(consumer, matrix, x, y + height, 0.0f, baseU, baseV + additionV, this.color, light);
            this.buildVertex(consumer, matrix, x + width, y + height, 0.0f, baseU + additionU, baseV + additionV, this.color, light);
            this.buildVertex(consumer, matrix, x + width, y, 0.0f, baseU + additionU, baseV, this.color, light);
            this.buildVertex(consumer, matrix, x, y, 0.0f, baseU, baseV, this.color, light);
        }
        pose.m_85849_();
        if (!shouldPush) {
            pose.m_85836_();
            pose.m_166854_(lastMatrix);
        }
    }

    public void renderNineSliceScaled(PoseStack pose, MultiBufferSource buffer, int light, boolean reverse, float r, int x, int y, int w, int h, int scale) {
        int border = (int)(r * (float)scale);
        float borderU = (float)border / (float)w;
        float borderV = (float)border / (float)h;
        float centerU = this.fuWidth - 2.0f * borderU;
        float centerV = this.fvHeight - 2.0f * borderV;
        this.renderUV(pose, buffer, x, y, border, border, this.fuOffset, this.fvOffset, borderU, borderV, light, reverse);
        this.renderUV(pose, buffer, x + border, y, w - 2 * border, border, this.fuOffset + borderU, this.fvOffset, centerU, borderV, light, reverse);
        this.renderUV(pose, buffer, x + w - border, y, border, border, this.fuOffset + this.fuWidth - borderU, this.fvOffset, borderU, borderV, light, reverse);
        this.renderUV(pose, buffer, x, y + border, border, h - 2 * border, this.fuOffset, this.fvOffset + borderV, borderU, centerV, light, reverse);
        this.renderUV(pose, buffer, x + border, y + border, w - 2 * border, h - 2 * border, this.fuOffset + borderU, this.fvOffset + borderV, centerU, centerV, light, reverse);
        this.renderUV(pose, buffer, x + w - border, y + border, border, h - 2 * border, this.fuOffset + this.fuWidth - borderU, this.fvOffset + borderV, borderU, centerV, light, reverse);
        this.renderUV(pose, buffer, x, y + h - border, border, border, this.fuOffset, this.fvOffset + this.fvHeight - borderV, borderU, borderV, light, reverse);
        this.renderUV(pose, buffer, x + border, y + h - border, w - 2 * border, border, this.fuOffset + borderU, this.fvOffset + this.fvHeight - borderV, centerU, borderV, light, reverse);
        this.renderUV(pose, buffer, x + w - border, y + h - border, border, border, this.fuOffset + this.fuWidth - borderU, this.fvOffset + this.fvHeight - borderV, borderU, borderV, light, reverse);
    }

    public void renderScaled(PoseStack pose, MultiBufferSource buffer, int light, float axis, boolean isWidth) {
        if (isWidth) {
            this.render(pose, buffer, axis, this.getFixedHeight(axis), light);
        } else {
            this.render(pose, buffer, this.getFixedWidth(axis), axis, light);
        }
    }

    public void renderCentered(PoseStack pose, MultiBufferSource buffer, float width, float height, int light) {
        this.translate(-width / 2.0f, height / 2.0f, 0.0);
        this.render(pose, buffer, width, height, light);
    }

    public void renderCenteredScaled(PoseStack pose, MultiBufferSource buffer, int light, float axis, boolean isWidth) {
        if (isWidth) {
            this.translate(-axis / 2.0f, this.getFixedHeight(axis) / 2.0f, 0.0);
            this.render(pose, buffer, axis, this.getFixedHeight(axis), light);
        } else {
            this.translate(-this.getFixedWidth(axis) / 2.0f, axis / 2.0f, 0.0);
            this.render(pose, buffer, this.getFixedWidth(axis), axis, light);
        }
    }

    private void buildVertex(VertexConsumer consumer, Matrix4f matrix, float x, float y, float z, float u, float v, SimpleColor color, int light) {
        consumer.m_85982_(matrix, x, y, z).m_85950_(color.getfR(), color.getfG(), color.getfB(), color.getA()).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public static interface RenderTypeBuilder {
        public RenderType build(ResourceLocation var1);
    }
}

