/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create;

import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.data.SpecialBlockStateGen;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.Nullable;

public class TrackStateGenerator
extends SpecialBlockStateGen {
    private final RotationGenerator xGen;
    private final RotationGenerator yGen;
    private final List<ModelBuilderContext> parentContext;
    private final String parentPath;

    public TrackStateGenerator(@Nullable RotationGenerator xGen, @Nullable RotationGenerator yGen, @Nonnull String parentPath) {
        this.xGen = xGen;
        this.yGen = yGen;
        this.parentContext = new ArrayList<ModelBuilderContext>();
        this.parentPath = parentPath;
    }

    protected int getXRotation(BlockState state) {
        return this.xGen != null ? this.xGen.apply(state) : 0;
    }

    protected int getYRotation(BlockState state) {
        return this.yGen != null ? this.yGen.apply(state) : 0;
    }

    public void modelBuilder(ModelBuilderContext context) {
        this.parentContext.add(context);
    }

    public <T extends Block> ModelFile getModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BlockState state) {
        TrackMaterial material = ((TrackBlock)ctx.getEntry()).getMaterial();
        String emptyModel = "block/air";
        TrackShape shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
        if (shape == TrackShape.NONE) {
            return prov.models().getExistingFile(prov.modLoc(emptyModel));
        }
        BlockModelProvider provider = prov.models();
        return this.buildModel(material, provider, shape, this.parentContext);
    }

    private BlockModelBuilder buildModel(TrackMaterial material, BlockModelProvider provider, TrackShape shape, List<ModelBuilderContext> contexts) {
        BlockModelBuilder builder = null;
        String prefix = "block/";
        for (ModelBuilderContext context : contexts) {
            if (builder == null) {
                if (context.type != ModelActionType.PARENT) continue;
                builder = (BlockModelBuilder)provider.withExistingParent(prefix + this.parentPath + "/" + shape.getModel(), new ResourceLocation(context.attr.m_135827_(), prefix + "/" + context.attr.m_135815_() + "/" + shape.getModel()));
                continue;
            }
            if (context.type != ModelActionType.PARENT) continue;
            builder = (BlockModelBuilder)builder.texture(context.boneName, context.attr == null ? material.particle : context.attr);
        }
        return builder;
    }

    public static interface RotationGenerator {
        public int apply(BlockState var1);
    }

    public record ModelBuilderContext(ModelActionType type, String boneName, ResourceLocation attr) {
        public static ModelBuilderContext of(ModelActionType type, String boneName, ResourceLocation location) {
            return new ModelBuilderContext(type, boneName, location);
        }
    }

    public static enum ModelActionType {
        PARENT,
        TEXTURE;

    }

    public static class Builder {
        private RotationGenerator xGen;
        private RotationGenerator yGen;
        private List<ModelBuilderContext> contexts;
        private String parentPath;

        protected Builder() {
        }

        public static Builder of(String parentPath) {
            Builder builder = new Builder();
            builder.parentPath = parentPath;
            builder.contexts = new ArrayList<ModelBuilderContext>();
            return builder;
        }

        public Builder xRotation(RotationGenerator xGen) {
            this.xGen = xGen;
            return this;
        }

        public Builder yRotation(RotationGenerator yGen) {
            this.yGen = yGen;
            return this;
        }

        public Builder addModelContext(ModelBuilderContext context) {
            this.contexts.add(context);
            return this;
        }

        public TrackStateGenerator build() {
            TrackStateGenerator generator = new TrackStateGenerator(this.xGen, this.yGen, this.parentPath);
            generator.parentContext.addAll(this.contexts);
            return generator;
        }
    }
}

