/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.module;

import java.util.HashMap;
import java.util.Optional;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.module.JavascriptModule;
import kasuga.lib.core.javascript.module.ModuleLoader;
import kasuga.lib.core.util.data_type.Pair;

public abstract class CachedModuleLoader
implements ModuleLoader {
    protected final HashMap<Pair<JavascriptContext, String>, JavascriptModule> cache = new HashMap();

    @Override
    public Optional<JavascriptModule> load(JavascriptModule source, String name) {
        Pair<JavascriptContext, String> cacheKey = Pair.of(source.getContext(), name);
        if (this.cache.containsKey(cacheKey)) {
            return Optional.of(this.cache.get(cacheKey));
        }
        Optional<JavascriptModule> module = this.getModule(source, name);
        module.ifPresent(m -> {
            HashMap<Pair<JavascriptContext, String>, JavascriptModule> hashMap = this.cache;
            synchronized (hashMap) {
                JavascriptModule actualModule = this.cache.computeIfAbsent(cacheKey, k -> m);
                source.getContext().collectEffect(() -> this.cache.remove(cacheKey, actualModule));
            }
        });
        return Optional.ofNullable(this.cache.get(cacheKey));
    }

    public abstract Optional<JavascriptModule> getModule(JavascriptModule var1, String var2);
}

