/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.module;

import java.util.ArrayList;
import java.util.List;
import kasuga.lib.core.addons.node.NodePackage;
import kasuga.lib.core.addons.node.PackageScanner;
import kasuga.lib.core.util.data_type.Pair;

public class JavascriptModuleScope {
    public final List<NodePackage> packages = new ArrayList<NodePackage>();
    public final JavascriptModuleScope parent;

    public JavascriptModuleScope() {
        this.parent = null;
    }

    public JavascriptModuleScope(JavascriptModuleScope parent) {
        this.parent = parent;
    }

    public List<Pair<NodePackage, String>> getPackage(String name) {
        List<String> parsedStrings = PackageScanner.splitPath(name);
        ArrayList<Pair<NodePackage, String>> result = new ArrayList<Pair<NodePackage, String>>();
        ArrayList<Pair<String, String>> mayPackageNames = new ArrayList<Pair<String, String>>();
        mayPackageNames.add(Pair.of(parsedStrings.get(0), PackageScanner.joinPath(parsedStrings.subList(1, parsedStrings.size()))));
        if (parsedStrings.size() > 1) {
            mayPackageNames.add(Pair.of(PackageScanner.joinPath(parsedStrings.subList(0, 2)), PackageScanner.joinPath(parsedStrings.subList(2, parsedStrings.size()))));
        }
        for (Pair pair : mayPackageNames) {
            for (NodePackage nodePackage : this.packages) {
                if (!nodePackage.packageName.equals(pair.getFirst())) continue;
                result.add(Pair.of(nodePackage, (String)pair.getSecond()));
            }
        }
        if (this.parent != null) {
            result.addAll(this.parent.getPackage(name));
        }
        return result;
    }
}

