/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.create;

import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import java.util.function.Predicate;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.create.InteractionMovementReg;
import kasuga.lib.registrations.registry.CreateRegistry;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;

public class InteractionReg<T extends MovingInteractionBehaviour>
extends Reg
implements InteractionMovementReg {
    private TagKey[] tags = null;
    private BlockReg[] blocks = null;
    private InteractionPredicate predicate = null;
    private Predicate<BlockReg> blockPredicate = null;
    private Predicate<BlockState> statePredicate = null;
    private MovingInteractionBehaviour behaviour = null;
    private WorkType workType = WorkType.blocks;

    public InteractionReg(String registrationKey) {
        super(registrationKey);
    }

    public InteractionReg<T> behaviour(T behaviour) {
        this.behaviour = behaviour;
        return this;
    }

    public InteractionReg<T> sortByTags(TagKey ... keys) {
        this.tags = keys;
        this.workType = WorkType.tag;
        return this;
    }

    public InteractionReg<T> sortByBlocks(BlockReg ... blocks) {
        this.blocks = blocks;
        this.workType = WorkType.blocks;
        return this;
    }

    public InteractionReg<T> mixedPredicate(InteractionPredicate predicate) {
        this.predicate = predicate;
        this.workType = WorkType.mixed_predicate;
        return this;
    }

    public InteractionReg<T> blockPredicate(Predicate<BlockReg> predicate) {
        this.blockPredicate = predicate;
        this.workType = WorkType.predicate;
        return this;
    }

    public InteractionReg<T> statePredicate(Predicate<BlockState> predicate) {
        this.statePredicate = predicate;
        this.workType = WorkType.state_predicate;
        return this;
    }

    @Override
    public InteractionReg<T> submit(SimpleRegistry registry) {
        if (!(registry instanceof CreateRegistry)) {
            this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "Use CreateRegistry instead of SimpleRegistry");
        }
        ((CreateRegistry)registry).cacheMovementIn(this);
        return this;
    }

    @Override
    public void onSetup() {
        if (this.behaviour == null) {
            this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "you must provide a type of interaction for registration");
        }
        switch (this.workType) {
            case blocks: {
                if (this.blocks == null) {
                    this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "you must provide a list of block for registration.");
                }
                for (BlockReg block : this.blocks) {
                    AllInteractionBehaviours.registerBehaviour(block.getBlock(), (MovingInteractionBehaviour)this.behaviour);
                }
                break;
            }
            case predicate: {
                if (this.blocks == null) {
                    this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "you must provide a list of block for registration.");
                }
                if (this.blockPredicate == null) {
                    this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "you must provide a predictor for registration.");
                }
                for (BlockReg block : this.blocks) {
                    if (!this.blockPredicate.test(block)) continue;
                    AllInteractionBehaviours.registerBehaviour(block.getBlock(), (MovingInteractionBehaviour)this.behaviour);
                }
                break;
            }
            case state_predicate: {
                if (this.statePredicate == null) {
                    this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "you must provide a predictor for registration.");
                }
                AllInteractionBehaviours.registerBehaviourProvider(state -> this.statePredicate.test(state) ? this.behaviour : null);
                break;
            }
            case tag: {
                if (this.tags == null) {
                    this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "you must provide a list of tags for registration.");
                }
                AllInteractionBehaviours.registerBehaviourProvider(state -> {
                    boolean flag = false;
                    for (TagKey tag : this.tags) {
                        if (!state.m_204336_(tag)) continue;
                        flag = true;
                        break;
                    }
                    return flag ? this.behaviour : null;
                });
                break;
            }
            case mixed_predicate: {
                if (this.blocks == null) {
                    this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "you must provide a list of block for registration.");
                }
                if (this.tags == null) {
                    this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "you must provide a list of tags for registration.");
                }
                for (BlockReg reg : this.blocks) {
                    boolean flag = false;
                    for (TagKey tag : this.tags) {
                        if (!this.predicate.test(reg, tag)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    AllInteractionBehaviours.registerBehaviour(reg.getBlock(), (MovingInteractionBehaviour)this.behaviour);
                }
                break;
            }
        }
    }

    @Override
    public String getIdentifier() {
        return "interaction_behaviour";
    }

    public static interface InteractionPredicate {
        public boolean test(BlockReg var1, TagKey var2);
    }

    protected static enum WorkType {
        blocks,
        predicate,
        state_predicate,
        mixed_predicate,
        tag;

    }
}

