/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.KasugaLibStacks;
import kasuga.lib.core.annos.Beta;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Util;
import kasuga.lib.core.base.SimpleCreativeTab;
import kasuga.lib.core.client.ModelMappings;
import kasuga.lib.core.client.render.model.CustomRenderedItemModel;
import kasuga.lib.registrations.BlockEntityRendererBuilder;
import kasuga.lib.registrations.client.AnimReg;
import kasuga.lib.registrations.client.KeyBindingReg;
import kasuga.lib.registrations.common.BlockEntityReg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.common.CommandReg;
import kasuga.lib.registrations.common.EntityReg;
import kasuga.lib.registrations.common.FluidBlockReg;
import kasuga.lib.registrations.common.MenuReg;
import kasuga.lib.registrations.registry.ModelRegistry;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRegistry {
    public final String namespace;
    public final IEventBus eventBus;
    private final Logger logger;
    private final DeferredRegister<SoundEvent> SOUNDS;
    private final DeferredRegister<Block> BLOCK;
    private final DeferredRegister<Item> ITEMS;
    private final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    private final DeferredRegister<MenuType<?>> MENUS;
    private final DeferredRegister<EntityType<?>> ENTITIES;
    private final DeferredRegister<Attribute> ATTRIBUTES;
    private final DeferredRegister<RecipeType<?>> RECIPES;
    private final DeferredRegister<MobEffect> EFFECT;
    private final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS;
    private final DeferredRegister<FluidType> FLUID_TYPE;
    private final DeferredRegister<Fluid> FLUID;
    private final ModelRegistry MODELS;
    private final HashMap<String, BlockEntityReg<?>> CACHE_OF_BLOCK_ENTITIES;
    private final HashMap<String, MenuReg<?, ?>> CACHE_OF_MENUS;
    private final HashMap<Supplier<Block>, BlockReg.BlockRendererBuilder<Block>> CACHE_OF_BLOCK_RENDERER;
    private final HashSet<EntityReg<?>> CACHE_OF_ENTITIES;
    private final HashSet<String> CUSTOM_RENDERED_ITEMS;
    private final HashSet<EntityReg<? extends LivingEntity>> CACHE_OF_LIVING_ENTITIES;
    private final ModelMappings modelMappings;
    private final HashMap<String, SimpleCreativeTab> TABS;
    private final HashMap<String, CommandReg> COMMANDS;
    private final HashMap<String, KeyBindingReg> KEY_BINDINGS;
    private final HashMap<String, AnimReg> ANIMS;

    public SimpleRegistry(String namespace, IEventBus bus) {
        this.namespace = namespace;
        this.eventBus = bus;
        this.logger = LoggerFactory.getLogger((String)(namespace + "/reg"));
        this.SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)namespace);
        this.BLOCK = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)namespace);
        this.ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)namespace);
        this.BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)namespace);
        this.MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)namespace);
        this.ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)namespace);
        this.RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)namespace);
        this.RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)namespace);
        this.EFFECT = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)namespace);
        this.ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)namespace);
        this.FLUID_TYPE = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)namespace);
        this.FLUID = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUIDS, (String)namespace);
        this.MODELS = new ModelRegistry(namespace, this);
        this.CACHE_OF_BLOCK_ENTITIES = new HashMap();
        this.CUSTOM_RENDERED_ITEMS = new HashSet();
        this.CACHE_OF_MENUS = new HashMap();
        this.CACHE_OF_LIVING_ENTITIES = new HashSet();
        this.modelMappings = new ModelMappings(namespace);
        this.CACHE_OF_ENTITIES = new HashSet();
        this.CACHE_OF_BLOCK_RENDERER = new HashMap();
        this.TABS = new HashMap();
        this.COMMANDS = new HashMap();
        this.KEY_BINDINGS = new HashMap();
        this.ANIMS = new HashMap();
    }

    public Logger logger() {
        return this.logger;
    }

    public DeferredRegister<SoundEvent> sound() {
        return this.SOUNDS;
    }

    public DeferredRegister<Block> block() {
        return this.BLOCK;
    }

    public DeferredRegister<Item> item() {
        return this.ITEMS;
    }

    public DeferredRegister<BlockEntityType<?>> blockEntity() {
        return this.BLOCK_ENTITIES;
    }

    public DeferredRegister<MenuType<?>> menus() {
        return this.MENUS;
    }

    public DeferredRegister<EntityType<?>> entity() {
        return this.ENTITIES;
    }

    @Beta
    public DeferredRegister<Attribute> attribute() {
        return this.ATTRIBUTES;
    }

    public DeferredRegister<RecipeType<?>> recipe() {
        return this.RECIPES;
    }

    public DeferredRegister<RecipeSerializer<?>> recipe_serializer() {
        return this.RECIPE_SERIALIZERS;
    }

    public DeferredRegister<MobEffect> mob_effect() {
        return this.EFFECT;
    }

    public DeferredRegister<FluidType> fluid_type() {
        return this.FLUID_TYPE;
    }

    public DeferredRegister<Fluid> fluid() {
        return this.FLUID;
    }

    public ModelRegistry model() {
        return this.MODELS;
    }

    public HashMap<String, SimpleCreativeTab> tab() {
        return this.TABS;
    }

    public HashMap<String, CommandReg> command() {
        return this.COMMANDS;
    }

    public HashMap<String, KeyBindingReg> key() {
        return this.KEY_BINDINGS;
    }

    public HashMap<String, AnimReg> animation() {
        return this.ANIMS;
    }

    @Util
    public ResourceLocation asResource(String path) {
        return new ResourceLocation(this.namespace, path);
    }

    @Mandatory
    public void submit() {
        this.SOUNDS.register(this.eventBus);
        this.BLOCK.register(this.eventBus);
        this.ITEMS.register(this.eventBus);
        this.FLUID_TYPE.register(this.eventBus);
        this.FLUID.register(this.eventBus);
        for (String key : this.CACHE_OF_BLOCK_ENTITIES.keySet()) {
            BlockEntityReg<?> reg = this.CACHE_OF_BLOCK_ENTITIES.get(key);
            try {
                reg.getType();
                reg.submit(this);
            }
            catch (Exception exception) {}
        }
        for (String key : this.CACHE_OF_MENUS.keySet()) {
            this.CACHE_OF_MENUS.get(key).submit(this);
        }
        this.BLOCK_ENTITIES.register(this.eventBus);
        this.MENUS.register(this.eventBus);
        this.ENTITIES.register(this.eventBus);
        this.RECIPES.register(this.eventBus);
        this.RECIPE_SERIALIZERS.register(this.eventBus);
        KasugaLib.STACKS.stackIn(this);
    }

    @Inner
    public void stackCustomRenderedItemIn(String registrationKey) {
        this.CUSTOM_RENDERED_ITEMS.add(registrationKey);
    }

    @Inner
    public ModelMappings modelMappings() {
        return this.modelMappings;
    }

    @Inner
    public void cacheBeIn(BlockEntityReg<?> entityReg) {
        this.CACHE_OF_BLOCK_ENTITIES.put(entityReg.registrationKey, entityReg);
    }

    @Inner
    public boolean hasBeCache(String registrationKey) {
        return this.CACHE_OF_BLOCK_ENTITIES.containsKey(registrationKey);
    }

    @Inner
    public BlockEntityReg<?> getBeCached(String registrationKey) {
        return this.CACHE_OF_BLOCK_ENTITIES.getOrDefault(registrationKey, null);
    }

    @Inner
    public void cacheMenuIn(MenuReg<?, ?> menuReg) {
        this.CACHE_OF_MENUS.put(menuReg.registrationKey, menuReg);
    }

    @Inner
    public boolean hasMenuCache(String registrationKey) {
        return this.CACHE_OF_MENUS.containsKey(registrationKey);
    }

    @Inner
    public MenuReg<?, ?> getMenuCached(String registrationKey) {
        return this.CACHE_OF_MENUS.getOrDefault(registrationKey, null);
    }

    public HashMap<String, MenuReg<?, ?>> getCahcedMenus() {
        return this.CACHE_OF_MENUS;
    }

    @Inner
    public void cacheLivingEntityIn(EntityReg<? extends LivingEntity> reg) {
        this.CACHE_OF_LIVING_ENTITIES.add(reg);
    }

    @Inner
    public HashSet<EntityReg<? extends LivingEntity>> getCachedLivingEntities() {
        return this.CACHE_OF_LIVING_ENTITIES;
    }

    @Inner
    public void cacheEntityIn(EntityReg<?> entityReg) {
        this.CACHE_OF_ENTITIES.add(entityReg);
    }

    @Inner
    public void cacheBlockRendererIn(BlockReg reg, BlockReg.BlockRendererBuilder rendererBuilder) {
        this.CACHE_OF_BLOCK_RENDERER.put(reg::getBlock, rendererBuilder);
    }

    @Inner
    public void cacheBlockRendererIn(FluidBlockReg reg, BlockReg.BlockRendererBuilder rendererBuilder) {
        this.CACHE_OF_BLOCK_RENDERER.put(reg::getBlock, rendererBuilder);
    }

    public void onBlockRendererReg() {
        KasugaLibStacks stacks = KasugaLib.STACKS;
        this.CACHE_OF_BLOCK_RENDERER.forEach((a, b) -> stacks.cacheBlockRendererIn((Block)a.get(), b.build(a).get()));
    }

    @Inner
    public void onEntityRendererReg() {
        this.CACHE_OF_ENTITIES.forEach(EntityReg::registerRenderer);
        this.CACHE_OF_BLOCK_ENTITIES.forEach((a, b) -> b.registerRenderer(this));
        this.CACHE_OF_BLOCK_ENTITIES.clear();
        this.CACHE_OF_ENTITIES.clear();
    }

    @Inner
    public void onCustomItemRendererReg(Map<ResourceLocation, BakedModel> registry) {
        for (String key : this.CUSTOM_RENDERED_ITEMS) {
            ModelResourceLocation location = new ModelResourceLocation(this.namespace, key, "inventory");
            if (!registry.containsKey(location)) continue;
            CustomRenderedItemModel model = new CustomRenderedItemModel(registry.get(location));
            registry.remove(location);
            registry.put((ResourceLocation)location, model);
        }
        this.CUSTOM_RENDERED_ITEMS.clear();
    }

    public void onAnimationReg() {
        this.ANIMS.forEach((k, v) -> v.onResourceLoading());
    }

    @Inner
    public <T extends BlockEntity> void registerBlockEntityRenderer(BlockEntityReg.BlockEntityProvider<T> type, BlockEntityRendererBuilder<T> rendererBuilder) {
        BlockEntityRenderers.m_173590_(type.provide(), rendererBuilder::build);
    }
}

