/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.math;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.math.MathOperation;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.math.RoundNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSBuiltin;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;

public abstract class RoundNode
extends MathOperation {
    private final ConditionProfile shiftProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile negativeLongBitsProfile = BranchProfile.create();
    private static final int EXP_BIAS = 1023;
    private static final int SIGNIFICAND_WIDTH = 53;
    private static final long EXP_BIT_MASK = 0x7FF0000000000000L;
    private static final long SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;

    RoundNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    public static RoundNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return RoundNodeGen.create(context, builtin, RoundNode.createCast(arguments));
    }

    protected static JavaScriptNode[] createCast(JavaScriptNode[] argumentNodes) {
        argumentNodes[0] = JSToNumberNode.create(argumentNodes[0]);
        return argumentNodes;
    }

    protected static boolean isCornercase(double d) {
        return Double.isNaN(d) || JSRuntime.isNegativeZero(d);
    }

    @Specialization
    protected static int roundInt(int a) {
        return a;
    }

    @Specialization(guards={"isCornercase(value)"})
    protected static double roundCornercase(double value) {
        return value;
    }

    private long round(double a) {
        long longBits = Double.doubleToRawLongBits(a);
        long biasedExp = (longBits & 0x7FF0000000000000L) >> 52;
        long shift = 1074L - biasedExp;
        if (this.shiftProfile.profile((shift & 0xFFFFFFFFFFFFFFC0L) == 0L)) {
            long r = longBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (longBits < 0L) {
                this.negativeLongBitsProfile.enter();
                r = -r;
            }
            return (r >> (int)shift) + 1L >> 1;
        }
        return (long)a;
    }

    @Specialization(guards={"!isCornercase(value)", "isDoubleInInt32Range(value)"}, rewriteOn={ArithmeticException.class})
    protected int roundDoubleInt(double value) {
        long longValue = this.round(value);
        if (longValue == 0L && value < 0.0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new ArithmeticException();
        }
        assert (JSRuntime.longIsRepresentableAsInt(longValue));
        return (int)longValue;
    }

    @Specialization(guards={"!isCornercase(value)"}, replaces={"roundDoubleInt"})
    protected double roundDouble(double value, @Cached(value="createBinaryProfile()") ConditionProfile profileA, @Cached(value="createBinaryProfile()") ConditionProfile profileB) {
        long longValue = this.round(value);
        if (profileA.profile(longValue == Long.MIN_VALUE || longValue == Long.MAX_VALUE)) {
            return value;
        }
        if (profileB.profile(longValue == 0L && value < 0.0)) {
            return -0.0;
        }
        return longValue;
    }
}

