/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Null;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public class GetMethodNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode cacheNode;
    @Node.Child
    private IsCallableNode isCallableNode;
    private final ConditionProfile undefinedOrNull = ConditionProfile.createBinaryProfile();
    private final BranchProfile notCallableBranch = BranchProfile.create();

    protected GetMethodNode(JSContext context, Object propertyKey) {
        this.cacheNode = PropertyGetNode.create(propertyKey, false, context);
        this.isCallableNode = IsCallableNode.create();
    }

    public static GetMethodNode create(JSContext ctx, Object key) {
        return new GetMethodNode(ctx, key);
    }

    public Object executeWithTarget(Object target) {
        Object method = this.cacheNode.getValue(target);
        if (this.isCallableNode.executeBoolean(method)) {
            return method;
        }
        if (this.undefinedOrNull.profile(method == Undefined.instance || method == Null.instance)) {
            return Undefined.instance;
        }
        this.notCallableBranch.enter();
        throw Errors.createTypeErrorNotAFunction(method, this);
    }
}

