/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Executed;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Property;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Shape;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.GlobalScopeNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.GlobalScopeTDZCheckNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Dead;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

abstract class GlobalScopeTDZCheckNode
extends GlobalScopeNode {
    final TruffleString varName;
    @Node.Child
    @Executed
    JavaScriptNode scopeNode;

    GlobalScopeTDZCheckNode(JSContext context, TruffleString varName) {
        super(context);
        this.varName = varName;
        this.scopeNode = GlobalScopeNode.create(context);
    }

    @Specialization(guards={"scope.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="context.getPropertyCacheLimit()")
    final Object doCached(JSDynamicObject scope, @Cached(value="scope.getShape()") Shape cachedShape, @Cached(value="isDead(cachedShape)") boolean dead) {
        assert (dead == (JSDynamicObject.getOrNull(scope, this.varName) == Dead.instance()));
        if (dead) {
            throw Errors.createReferenceErrorNotDefined(this.context, this.varName, this);
        }
        return scope;
    }

    @Specialization(replaces={"doCached"})
    final Object doUncached(Object scope, @Cached(value="create(varName, context)") PropertyGetNode getNode, @Cached(value="create()") BranchProfile deadBranch) {
        if (getNode.getValue(scope) == Dead.instance()) {
            deadBranch.enter();
            throw Errors.createReferenceErrorNotDefined(this.context, this.varName, this);
        }
        return scope;
    }

    final boolean isDead(Shape shape) {
        Property property = shape.getProperty(this.varName);
        return property != null && property.getLocation().isConstant() && property.getLocation().getConstantValue() == Dead.instance();
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return GlobalScopeTDZCheckNodeGen.create(this.context, this.varName);
    }
}

