/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary;

import java.util.Objects;
import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.NodeInfo;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.Truncatable;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSConstantNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSLeftShiftConstantNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSLeftShiftNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSLeftShiftNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.SafeInteger;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;

@NodeInfo(shortName="<<")
public abstract class JSLeftShiftConstantNode
extends JSUnaryNode {
    protected final int shiftValue;

    protected JSLeftShiftConstantNode(JavaScriptNode operand, int shiftValue) {
        super(operand);
        this.shiftValue = shiftValue;
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        assert (right instanceof JSConstantNode.JSConstantIntegerNode);
        int shiftValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null);
        if (left instanceof JSConstantNode.JSConstantIntegerNode) {
            int leftValue = ((JSConstantNode.JSConstantIntegerNode)left).executeInt(null);
            return JSConstantNode.createInt(leftValue << shiftValue);
        }
        Truncatable.truncate(left);
        return JSLeftShiftConstantNodeGen.create(left, shiftValue);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = JSConstantNode.createInt(this.shiftValue);
            JSLeftShiftNode node = JSLeftShiftNodeGen.create(JSLeftShiftConstantNode.cloneUninitialized(this.getOperand(), materializedTags), constantNode);
            JSLeftShiftConstantNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSLeftShiftConstantNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    public abstract int executeInt(Object var1);

    @Specialization
    protected int doInteger(int a) {
        return a << this.shiftValue;
    }

    @Specialization
    protected int doSafeInteger(SafeInteger a) {
        return a.intValue() << this.shiftValue;
    }

    @Specialization
    protected int doDouble(double a, @Cached(value="create()") JSToInt32Node leftInt32Node) {
        return leftInt32Node.executeInt(a) << this.shiftValue;
    }

    @Specialization
    protected void doBigInt(BigInt a) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization
    protected Object doOverloaded(JSOverloadedOperatorsObject a, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, this.shiftValue);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_OPEN_2;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)"}, replaces={"doInteger", "doSafeInteger", "doDouble", "doBigInt"})
    protected Object doGeneric(Object a, @Cached(value="create()") JSToNumericNode leftToNumericNode, @Cached(value="makeCopy()") JSLeftShiftConstantNode innerShiftNode) {
        Object numericLeft = leftToNumericNode.execute(a);
        return innerShiftNode.executeInt(numericLeft);
    }

    protected JSLeftShiftConstantNode makeCopy() {
        return (JSLeftShiftConstantNode)this.copyUninitialized(null);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSLeftShiftConstantNodeGen.create(JSLeftShiftConstantNode.cloneUninitialized(this.getOperand(), materializedTags), this.shiftValue);
    }

    @Override
    public String expressionToString() {
        if (this.getOperand() != null) {
            return "(" + Objects.toString(this.getOperand().expressionToString(), "(intermediate value)") + " << " + this.shiftValue + ")";
        }
        return null;
    }
}

