/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.CachedLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Shape;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.ReadElementNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.WriteElementNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop.ExportValueNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop.ImportValueNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.TypedArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSArrayBufferViewBase;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.TypedArrayAccess;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.interop.InteropArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTypedArrayObject
extends JSArrayBufferViewBase {
    TypedArray arrayType;

    protected JSTypedArrayObject(Shape shape, TypedArray arrayType, JSArrayBufferObject arrayBuffer, int length, int offset) {
        super(shape, arrayBuffer, length, offset);
        this.arrayType = arrayType;
    }

    public TypedArrayAccess typedArrayAccess() {
        return TypedArrayAccess.SINGLETON;
    }

    public TypedArray getArrayType() {
        return this.arrayType;
    }

    public static JSTypedArrayObject create(Shape shape, TypedArray arrayType, JSArrayBufferObject arrayBuffer, int length, int offset) {
        return new JSTypedArrayObject(shape, arrayType, arrayBuffer, length, offset);
    }

    @Override
    public TruffleString getClassName() {
        return this.typedArrayAccess().getTypedArrayName(this);
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        return Strings.UC_OBJECT;
    }

    @ExportMessage
    public Object getMembers(boolean includeInternal) {
        assert (JSObject.getJSClass(this) == JSArrayBufferView.INSTANCE);
        return InteropArray.create(JSTypedArrayObject.filterEnumerableNames(this, JSNonProxy.ordinaryOwnPropertyKeys(this), JSArrayBufferView.INSTANCE));
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public long getArraySize() {
        return JSArrayBufferView.typedArrayGetLength(this);
    }

    @ExportMessage
    public Object readArrayElement(long index, @CachedLibrary(value="this") InteropLibrary self, @Cached(value="create(language(self).getJSContext())", uncached="getUncachedRead()") ReadElementNode readNode, @Cached ExportValueNode exportNode) throws InvalidArrayIndexException, UnsupportedMessageException {
        JSTypedArrayObject target = this;
        if (index < 0L || index >= self.getArraySize(this)) {
            throw InvalidArrayIndexException.create(index);
        }
        Object result = readNode == null ? JSObject.getOrDefault((JSDynamicObject)target, index, (Object)target, (Object)Undefined.instance) : readNode.executeWithTargetAndIndexOrDefault(target, index, Undefined.instance);
        return exportNode.execute(result);
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable")})
    public boolean isArrayElementReadable(long index, @CachedLibrary(value="this") InteropLibrary thisLibrary) {
        try {
            return index >= 0L && index < thisLibrary.getArraySize(this);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.shouldNotReachHere(e);
        }
    }

    @ExportMessage
    public void writeArrayElement(long index, Object value, @Cached ImportValueNode castValueNode, @Cached(value="createCachedInterop()", uncached="getUncachedWrite()") WriteElementNode writeNode, @CachedLibrary(value="this") InteropLibrary thisLibrary) throws InvalidArrayIndexException, UnsupportedMessageException {
        JSTypedArrayObject target = this;
        if (index < 0L || index >= thisLibrary.getArraySize(this)) {
            throw InvalidArrayIndexException.create(index);
        }
        Object importedValue = castValueNode.executeWithTarget(value);
        if (writeNode == null) {
            JSObject.set((JSDynamicObject)target, index, importedValue, true, null);
        } else {
            writeNode.executeWithTargetAndIndexAndValue((Object)target, index, importedValue);
        }
    }

    @ExportMessage
    public boolean isArrayElementInsertable(long index) {
        return false;
    }
}

