/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.interop;

import java.util.List;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.TruffleObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class InteropList
implements TruffleObject {
    final List<? extends Object> list;

    private InteropList(List<? extends Object> list) {
        this.list = list;
    }

    public static TruffleObject create(List<? extends Object> list) {
        return new InteropList(list);
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            throw InvalidArrayIndexException.create(index);
        }
        return this.list.get((int)index);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long getArraySize() {
        return this.list.size();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < (long)this.list.size();
    }
}

